#include "mbed.h"
#include "DS1820.h"

Serial serial(USBTX, USBRX);

int main()
{
    DS1820  ds1820(PA_0);    // substitute PA_0 with actual mbed pin name connected to the DS1820 data pin

    if(ds1820.begin()) {
        ds1820.setResolution(12);
        ds1820.startConversion();
        wait(1.0);
        while(1) {
            serial.printf("temp = %3.1f\r\n", ds1820.read());     // read temperature
            ds1820.startConversion();     // start temperature conversion
            wait(1.0);                    // let DS1820 complete the temperature conversion
        }
    } else
        serial.printf("No DS1820 sensor found!\r\n");
}
