
#include "mbed.h"
#include "C12832.h"
#include "CanreceiveLib.h"

Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10);
CAN can2(p30, p29);
char message[8];
int countvitesse = 1;
float gvitesse = 0;
char dpvitesse;
float gregmoteur = 0;
char dpregmoteur;
#define canfrequency 500000
#define idvitesse 0x38D
#define lnvitesse 5
#define idregime 0x208
#define lnregime 8

// Vitesse 38D : 5 octets / période 40 ms (octet1*256+octet2)*0.01
// Regime moteur 208 : 8 octets / période 10 ms (octet1*256+octet2)*0.125

AnalogIn vit(p20);
AnalogIn regm(p19);
C12832 lcd(p5, p7, p6, p8, p11);

void send()
{
    unsigned int regime_moteur = (unsigned)(regm.read() * 65535.0);
    message[0] = regime_moteur >> 8;
    message[1] = regime_moteur - message[0] <<8;
    can1.write(CANMessage(idregime, message, lnregime));
    if (!(--countvitesse)) {
        countvitesse = 4;
        unsigned int vitesse = (unsigned)(vit.read() * 25000.0);
        message[0] = vitesse >> 8;
        message[1] = vitesse - message[1] <<8;
        wait_us(100);
        can1.write(CANMessage(idvitesse, message, lnvitesse));
    }
}
void can2reader(void)
{
    CANMessage msg;
    float calcul;
    if(can2.read(msg)) {
        calcul = msg.data[0] << 8 + msg.data[1];
        if (msg.id == idvitesse) {
            gvitesse = calcul * 0.01;
            dpvitesse = true;
        } else if (msg.id == idregime) {
            gregmoteur = calcul * 0.125;
            dpregmoteur = true;
        }
    }
}

int main()
{
    can1.frequency(canfrequency);
    can2.frequency(canfrequency);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Hello simulation BUS can Vers 2");
    ticker.attach(&send, 0.01);
    can2.attach(&can2reader);
    while(1) {
        if (dpvitesse) {
            lcd.locate(2,11);
            lcd.printf("Vitesse   %3.0fkm/h\r\n",gvitesse);
            dpvitesse = false;
        } else if (dpregmoteur) {
            lcd.locate(2,22);
            lcd.printf("Reg mot %4.0ftr/min\r\n",gregmoteur);
            dpregmoteur = false;
        }
    }
}
