#include "FT_Platform.h"
#include "mbed.h"

/* function to load jpg file from filesystem */
/* return 0 if jpg is ok                     */
/* return x_size and y_size of jpg           */

int FT800::Load_jpg(char* filename, ft_int16_t* x_size, ft_int16_t* y_size)
{
    unsigned char pbuff[8291];
    unsigned short marker;
    unsigned short length;
    unsigned char data[4];

    ft_uint16_t blocklen;

    FILE *fp = fopen(filename, "r");
    if(fp == NULL) return (-1);         // connot open file

    // search for 0xFFC0 marker
    fseek(fp, 0, SEEK_END);
    unsigned int Fsize = ftell(fp);
    fseek(fp, 2, SEEK_SET);
    fread(data,4,1,fp);
    marker = data[0] << 8 | data[1];
    length = data[2] << 8 | data[3];
    do {
        if(marker == 0xFFC0) break;
        if(marker & 0xFF00 != 0xFF00) break;
        if (fseek(fp, length - 2,SEEK_CUR) != 0) break;
        fread(data,4,1,fp);
        marker = data[0] << 8 | data[1];
        length = data[2] << 8 | data[3];
    } while(1);
    if(marker != 0xFFC0) return (-2);  // no FFC0 Marker, wrong format no baseline DCT-based JPEG
    fseek(fp, 1,SEEK_CUR);
    fread(data,4,1,fp);
    *y_size = (data[0] << 8 | data[1]);
    *x_size = (data[2] << 8 | data[3]);

    //if(*x_size > DispWidth || *y_size > DispHeight) return (-3);  // to big to fit on screen

    fseek(fp, 0, SEEK_SET);
    WrCmd32(CMD_LOADIMAGE);  // load a JPEG image
    WrCmd32(0);              //destination address of jpg decode
    WrCmd32(0);              //output format of the bitmap - default is rgb565
    while(Fsize > 0) {
        /* download the data into the command buffer by 8kb one shot */
        blocklen = Fsize>8192?8192:Fsize;
        /* copy the data into pbuff and then transfter it to command buffer */
        fread(pbuff,1,blocklen,fp);
        Fsize -= blocklen;
        /* copy data continuously into command memory */
        WrCmdBuf(pbuff, blocklen); //alignment is already taken care by this api
    }
    fclose(fp);

    return(0);
}


/* calibrate touch */
ft_void_t FT800::Calibrate()
{
    /*************************************************************************/
    /* Below code demonstrates the usage of calibrate function. Calibrate    */
    /* function will wait untill user presses all the three dots. Only way to*/
    /* come out of this api is to reset the coprocessor bit.                 */
    /*************************************************************************/
    {

        DLstart();                                       // start a new display command list
        DL(CLEAR_COLOR_RGB(64,64,64));       // set the clear color R, G, B
        DL(CLEAR(1,1,1));                    // clear buffers -> color buffer,stencil buffer, tag buffer
        DL(COLOR_RGB(0xff,0xff,0xff));       // set the current color R, G, B
        Text((DispWidth/2), (DispHeight/2), 27, OPT_CENTER, "Appuyez sur les points");  // draw Text at x,y, font 27, centered
        Calibrate(0);                                    // start the calibration of touch screen
        Flush_Co_Buffer();                               // download the commands into FT800 FIFO
        WaitCmdfifo_empty();                             // Wait till coprocessor completes the operation
    }
}


