
#include "mbed.h"
#include "FT800_lib_perso.h"

MyFT800::MyFT800(PinName mosi, PinName miso, PinName sck, PinName ss,PinName intr,PinName pd) :
    FT800(mosi,miso,sck,ss,intr,pd)
{
}

ft_void_t MyFT800::Brightness(ft_int32_t lum)
{
    DLstart(); // wait until after the swap
    MemWrite(REG_PWM_DUTY, 4); // write to the PWM_DUTY register
    StartFunc( FT_CMD_SIZE*1);
    SendCmd(lum);
    EndFunc( (FT_CMD_SIZE*1));
    Flush_Co_Buffer();                 // Download the command list into fifo
    WaitCmdfifo_empty();
}

ft_void_t MyFT800::Drawline( ft_int32_t x0, ft_int32_t y0,ft_int32_t x1,ft_int32_t y1)
{
    DL(BEGIN(LINES));
    DL(VERTEX2F(x0*16,y0*16));
    DL(VERTEX2F(x1*16,y1*16));
}


/******************************************  new 2022  */
// trace rectangle et le rempli
ft_void_t MyFT800::Drawrectanglefull( ft_int32_t x0, ft_int32_t y0,ft_int32_t x1,ft_int32_t y1)
{
    ft_int32_t xi0,xi1, yi0,yi1;
    if (x0<x1) {
        xi0 = x0;
        xi1 = x1;
    } else {
        xi0 = x1;
        xi1 = x0;
    }
    if (y0<y1) {
        yi0 = y0;
        yi1 = y1;
    } else {
        yi0 = y1;
        yi1 = y0;
    }
    DL(SCISSOR_XY(xi0,yi0));
    DL(SCISSOR_SIZE(xi1-xi0,yi1-yi0));
    DL(CLEAR(1,1,1));
    DL(SCISSOR_XY(0,0));
    DL(SCISSOR_SIZE(my_DispWidth,my_DispHeight));
}
/******************************************  new 2022  */
ft_void_t MyFT800::Drawrectangleempty( ft_int32_t x0, ft_int32_t y0,ft_int32_t x1,ft_int32_t y1)
{
    Drawline(x0,y0,x1,y0);
    Drawline(x1,y0,x1,y1);
    Drawline(x1,y1,x0,y1);
    Drawline(x0,y1,x0,y0);
}