#include "ecran.h"
#include "LCD_DISCO_F746NG.h"
#include "fonts.h"

char EcranPhrase[20]; // pour stocker phrase affichage
uint32_t MaxX ;
uint32_t MaxY ;
LCD_DISCO_F746NG lcd;

void FirstEcran(void)
{
    MaxX = lcd.GetXSize();
    MaxY = lcd.GetYSize();
    lcd.SetFont(&Font12);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0,0, MaxX-1, MaxY/10);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.DisplayStringAt(0, MaxY/30, (uint8_t *)"Soufflerie Eolia simulation dialogue PID", CENTER_MODE);
    // titre
    lcd.DisplayStringAt(3*MaxX/40, MaxY/5+LINE(0), (uint8_t *)"  Correcteur PID     ", LEFT_MODE);
    lcd.DisplayStringAt(MaxX/2+MaxX/40, MaxY/5+LINE(0), (uint8_t *)"  Consigne flux air     ", LEFT_MODE);
    lcd.DisplayStringAt(MaxX/2+MaxX/40, MaxY/5+LINE(8), (uint8_t *)"  Mesures     ", LEFT_MODE);
    lcd.SetBackColor(LCD_COLOR_YELLOW);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    // PHRASE PARAM PID
    lcd.DisplayStringAt(3*MaxX/40, MaxY/5+LINE(6), (uint8_t *)"PC --> $L,Kp,Ki,Kd\\r\\n", LEFT_MODE);
    // PHRASE PARAM CONSIGNE FLUX AIR
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(5), (uint8_t *)"PC --> $BCVfair\\r\\n", LEFT_MODE);
    // PHRASE MESURES FLUX AIR FREQ HELICE
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(15), (uint8_t *)(uint8_t *)"$V,Vfair,FHelice\\r\\n --> PC", LEFT_MODE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    // correcteur PID
    sprintf(EcranPhrase,"- Kp : %f",coefp);
    lcd.DisplayStringAt(4*MaxX/40, MaxY/5+LINE(2), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- Ki : %f",coefi);
    lcd.DisplayStringAt(4*MaxX/40, MaxY/5+LINE(3), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- Kd : %f",coefd);
    lcd.DisplayStringAt(4*MaxX/40, MaxY/5+LINE(4), (uint8_t *)EcranPhrase, LEFT_MODE);
    // consigne vitesse flux air
    sprintf(EcranPhrase,"- %0.1fm/s",ConsVitFluxAir/3.6);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(2), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- %0.1fkm/h",ConsVitFluxAir);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(3), (uint8_t *)EcranPhrase, LEFT_MODE);
    // vitesse flux air
    sprintf(EcranPhrase,"- Vflux Air : %0.1fm/s",VitFluxAir/3.6);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(10), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- Vflux Air : %0.1fkm/h",VitFluxAir);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(11), (uint8_t *)EcranPhrase, LEFT_MODE);
    // frequence helice
    sprintf(EcranPhrase,"- Freq Hel : %0.1ftr/s",Frequencehelice);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(13), (uint8_t *)EcranPhrase, LEFT_MODE);
}

void Ecran(void)
{
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(4*MaxX/40+1, MaxY/5+LINE(2),MaxX-8*MaxX/40+1,LINE(3));
    lcd.FillRect(MaxX/2+2*MaxX/40+1, MaxY/5+LINE(10),MaxX-MaxX/2-6*MaxX/40+1,LINE(4));
    lcd.SetTextColor(LCD_COLOR_WHITE);
    // correcteur PID
    sprintf(EcranPhrase,"- Kp : %f",coefp);
    lcd.DisplayStringAt(4*MaxX/40, MaxY/5+LINE(2), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- Ki : %f",coefi);
    lcd.DisplayStringAt(4*MaxX/40, MaxY/5+LINE(3), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- kd : %f",coefd);
    lcd.DisplayStringAt(4*MaxX/40, MaxY/5+LINE(4), (uint8_t *)EcranPhrase, LEFT_MODE);
    // consigne vitesse flux air
    sprintf(EcranPhrase,"- %0.1fm/s",ConsVitFluxAir/3.6);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(2), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- %0.1fkm/h",ConsVitFluxAir);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(3), (uint8_t *)EcranPhrase, LEFT_MODE);
    // vitesse flux air
    sprintf(EcranPhrase,"- Vflux Air : %0.1fm/s",VitFluxAir/3.6);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(10), (uint8_t *)EcranPhrase, LEFT_MODE);
    sprintf(EcranPhrase,"- Vflux Air : %0.1fkm/h",VitFluxAir);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(11), (uint8_t *)EcranPhrase, LEFT_MODE);
    // frequence helice
    sprintf(EcranPhrase,"- Freq Hel : %0.1ftr/s",Frequencehelice);
    lcd.DisplayStringAt(MaxX/2+2*MaxX/40, MaxY/5+LINE(13), (uint8_t *)EcranPhrase, LEFT_MODE);
}