#include "mbed.h"
#include "C12832.h"
#include "platform/mbed_thread.h"

// Rate acquisition
#define BLINKING_RATE_MS  500
C12832 lcd(D11, D13, D12, D7, D10);
AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

int main()
{
    float Entree1,Entree2;
    while (true) {
        // acqusition des entrees
        Entree1 = 3.3*pot1.read();
        Entree2 = 3.3*pot2.read();
        // traitement de l entree1
 
        lcd.cls();
        lcd.locate(0,3);
        if ( Entree1 < 0.36 ) {
            lcd.printf("COURT CIRCUIT\n");
        } else if ( Entree1 < 0.88 ) {
            lcd.printf("ANOMALIE\n");
        } else if ( Entree1 < 1.41 ) {
            lcd.printf("PAS ANOMALIE\n");
        } else {
            lcd.printf("COUPE DE CABLE\n");
        }

        lcd.locate(0,14);
        lcd.printf("Pot 2 = %.2f", Entree2);

        thread_sleep_for(BLINKING_RATE_MS);   //wait....
    }
}
