#include "mbed.h"
#include "FT_Platform.h"
#include "affichage.h"

// NUCLEO F411RE
FT800 TFT (PB_5,PB_4,PB_3,PA_8,PB_10,PA_9); // mosi, miso, sck, ss, int, pd
char sliderVal = 0;

// Variable pour les donnees a afficher 
// en liaison SP1 et Tablette
volatile unsigned char ConsigneVitFluxAir; // Vitesse de Flux d'air consigne  
volatile unsigned char MesVitFluxAir; //Vitesse de Flux d'air mesure Sp1
volatile unsigned char TempSoufflerie; // temperature chambre soufflerie Sp1
volatile unsigned char HumiditéSoufflerie; // humidite chambre soufflerie SP1

// en liaison SP1 et Tablette
volatile signed char ConsigneAngleIncid ; // Vitesse de Flux d'air consigne 

volatile signed char ConsigneChampPression[8] ; // Vitesse de Flux d'air consigne 

/*
Angle incidence mesure
Champs de pression : 8 valeurs
Cx : coefficients de traînée (C_x)
Cz : coefficients de portance (C_z)
*/

// permet d'indiquer qu'une variable a changer et qu'il faut reafficher l'ecran

volatile bool DataChange = true; // true indique qu'il faut afficher l'ecran

// permet d'affecter une valeur a consigne de flux d'air
void SetConsigneVitFluxAir(unsigned char variable)
{
    ConsigneVitFluxAir = variable;
    DataChange = true;
    }

void InitScreen(void)
{
    luminosite(128);
    TFT.Calibrate();
    TFT.Track(244, 45, 161, 17, 2);
}

ft_void_t luminosite( ft_int32_t lum)
{
    TFT.DLstart(); // wait until after the swap
    TFT.MemWrite(REG_PWM_DUTY, 4); // write to the PWM_DUTY register
    TFT.StartFunc( FT_CMD_SIZE*1);
    TFT.SendCmd(lum);
    TFT.EndFunc( (FT_CMD_SIZE*1));
    TFT.Flush_Co_Buffer();                 // Download the command list into fifo
    TFT.WaitCmdfifo_empty();
}

ft_void_t drawline( ft_int32_t x0, ft_int32_t y0,ft_int32_t x1,ft_int32_t y1)
{
    TFT.DL(BEGIN(LINES));
    TFT.DL(VERTEX2F(x0*16,y0*16));
    TFT.DL(VERTEX2F(x1*16,y1*16));
}

/***********************************************************************************************************************/
/* Construct the screen and downloasd it to the TFT */
void AfficheEcranSp3()
{
    
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));
    TFT.DL(CLEAR(1, 1, 1));

    TFT.FgColor(0xC1004D);

    TFT.Keys(27, 127, 271, 41, 29, 0, "123");

    TFT.DL(TAG(1));
    TFT.Button(31, 32, 148, 57, 27, OPT_FLAT, "Button");

    TFT.DL(TAG(2));
    TFT.Slider(244, 45, 161, 17, 0, sliderVal, 255);

    // track the touch screen 
    // a sortir mettre dans une fonction qui gere le tactile si besoins
    
    char pressedButton = TFT.Rd8(REG_TOUCH_TAG);
    int pressedSlider = TFT.Rd32(REG_TRACKER);
    if (pressedButton == 2) {
        sliderVal = (pressedSlider >> 16) * 255 / 65536;
    }

    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(28, 213, 28, 0, "REG_TOUCH_TAG");
    TFT.Text(28, 237, 28, 0, "REG_TRACKER");
    
 
    TFT.Number(230, 237, 28, 0, pressedButton);
    TFT.Number(230, 213, 28, 0, sliderVal);

// pour afficher variable consigne vitesse de flux d'air

    TFT.Text(28, 190, 28, 0, "Consigne flux dair");      
    TFT.Number(230, 190, 28, 0, ConsigneVitFluxAir);   
    drawline(28,191,470,191);

    TFT.DL(DISPLAY());
    TFT.Swap();
    TFT.Flush_Co_Buffer();
    TFT.WaitCmdfifo_empty();
    DataChange = false;
}