#include "mbed.h"
#include "platform/mbed_thread.h"
#include "sim800l.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS 500
RawSerial pc(USBTX,USBRX);
Ticker T1s;
bool EnvoiSms30s;
int heure=0, minute=0, seconde=0;
char Phrase[1000]; // pour convertir en phrase avant envoi
void Ft1s()
{
    if (seconde >= 59) {
        seconde = 0;
        if (minute >= 59) {
            minute = 0;
            if (heure >= 23) heure = 0;
            else heure++;
        } else minute++;
    } else seconde ++;
    if ((seconde == 0)||(seconde == 30)) EnvoiSms30s = true;
}
Sim800l Sim800L(PC_10,PC_11,PC_12,115200);

int main()
{
    EnvoiSms30s = false;
    pc.baud(921600);
    pc.printf("Bonjour\r\n");
    pc.printf("Patientez init sim800l : ");
    if (Sim800L.init()) pc.printf("ok.\r\n");
    else pc.printf("Erreur.\r\n");
    pc.printf("Efface all SMS : ");
    if (Sim800L.smsclearall()) pc.printf("ok.\r\n");
    else pc.printf("Erreur.\r\n");
    pc.printf("Envoi Sms : ");
    if (Sim800L.sendsms("+33xxxxxxxxx","Bonjour 22-04-2022")) pc.printf("ok.\r\n");
    else pc.printf("erreur.\r\n");
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    T1s.attach(callback(&Ft1s),1);
    while (true) {
        //      led = !led;
        //      thread_sleep_for(BLINKING_RATE_MS);
        if (EnvoiSms30s) {
            pc.printf("Envoi sms 30s : ");
            sprintf(Phrase,"time %d:%d:%d\r\n",heure,minute,seconde);
            if (Sim800L.sendsms("+33xxxxxxxxx",Phrase)) pc.printf("ok.\r\n");
            else pc.printf("erreur.\r\n");
            EnvoiSms30s = false;
        }
        if (Sim800L.smsready()) {
            led = 1;
            pc.printf("Recois SMS, index : %d\r\n",Sim800L.IndexSmsRecu());
            Sim800L.readsms(Sim800L.IndexSmsRecu());
            pc.printf("Texte sms recu --- \r\n%s\r\n",Sim800L.readtextesms());
            pc.printf("Reponse SMS : ");
            if (Sim800L.sendsms("+33xxxxxxxxx",Sim800L.readtextesms())) pc.printf("ok.\r\n");
            else pc.printf("erreur.\r\n");
            led = 0;
        }
    }
}
