#include "mbed.h"
#include "platform/mbed_thread.h"
#include "sim5320e.h"
#include "MySerial.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS 500
MySerial pc(USBTX,USBRX);
char PCPhrase[maxdata+1];    // pour stocker phrase PC
int NumQuad;
char NumTel[20];


sim5320e Sim5320e(PA_9,PA_10,PA_12,115200); // L432KC
//sim5320e Sim5320e(PC_10,PC_11,PC_12,115200); // F746
int main()
{
    pc.baud(921600);
    pc.printf("Bonjour\r\n");
    pc.printf("Patientez init Sim5320e : \r\n");
    if (Sim5320e.init()) pc.printf("ok.\r\n");
    else pc.printf("Erreur.\r\n");
    pc.printf("Patientez configure service sms : \r\n");
    if (Sim5320e.smsinit()) pc.printf("Ok.\r\n");
    else pc.printf("Erreur.\r\n");
    pc.printf("Efface all SMS : \r\n");
    if (Sim5320e.smsclearall()) pc.printf("ok.\r\n");
    else pc.printf("Erreur.\r\n");
// ACTIVER CI DESSOUS ET DEFINIR NUM TEL
//   pc.printf("Pret envoi un sms : \r\n");
//    if (Sim5320e.sendsms("+33XXXXXXX","Bonjour envoi Sms" )) pc.printf("ok.\r\n");
//    else pc.printf("erreur.\r\n");
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    while (true) {
        if (pc.dataready()) {
            strcpy(PCPhrase,pc.read());
            switch (PCPhrase[1]) {
                case 'n': // nouvelle location
                    if (sscanf(PCPhrase,"$n,%d,%s",&NumQuad,NumTel)>=1) {
                        while (!pc.writeable());
                        pc.printf("recu de pc %s pour quad %d telephone %s\r\n",PCPhrase,NumQuad, NumTel);
                        if (Sim5320e.sendsms(NumTel,PCPhrase)) pc.printf("SMS ENVOI OK\r\n");
                        else pc.printf("SMS Erreur ENVOI\r\n");
                    }
                    break;
                default :
                    ;
            }
        }
        if (Sim5320e.smsready()) {
            while(!pc.writeable());
            pc.printf("RECOIT SMS QUAD :\r\n ------------------------------------ \r\n");

            led = 1;
            Sim5320e.readsms(Sim5320e.IndexSmsRecu());
            while (!pc.writeable());
            pc.printf("%s\r\n",Sim5320e.readtextesms());
            led = 0;
        }
    }
}
