#include "mbed.h"
#include "MySerial.h"
#include "ecran.h"

// variable soufflerie
float ConsVitFluxAir;  // consigne flux air
float VitFluxAir; // vitesse de flux air
float Frequencehelice;
// coef correcteur PID
float coefp,coefi,coefd;
// interface PC attention baud 921600
MySerial PC(USBTX,USBRX); // liaison PC
char PCPhrase[maxdata];    // pour stocker phrase PC
float presangle;
volatile char EnvoiePC = 0; // INDIQUE DONNEE A ENVOYER EN PC ET CODE TRAME
Ticker ticker;
unsigned int Nb = 1;
void Tenvoi(void)
{
    EnvoiePC = 'V';
}

DigitalOut led_green(LED1);


Ticker tickermes;
bool datachange = false;
void mes(void)
{
    datachange = true;
    VitFluxAir++; // vitesse de flux air
    if (VitFluxAir>70) VitFluxAir = 0;
    Frequencehelice++;
    if (Frequencehelice>180) Frequencehelice = 0;
}


int main()
{
    coefp=0;
    coefi=0;
    coefd=100000;
    Frequencehelice = 100;
    ConsVitFluxAir = 57;  // consigne flux air
    VitFluxAir =30;
    Ecran();
    ticker.attach(&Tenvoi,0.1); // demare ticker pour envoi trame toute les 100ms
    tickermes.attach(&mes,10); // demare ticker pour envoi trame toute les 100ms
    FirstEcran();
    while(1) {

// recevoir des donnees
        if (PC.dataready()) {
            strcpy(PCPhrase,PC.read());
            switch (PCPhrase[1]) {
                case 'B': // consigne de flux air
                    ConsVitFluxAir = atof(PCPhrase+2);
                    datachange=true;
                    break;
                case 'L' :  // param pid
                    if (sscanf(PCPhrase,"$L,%f,%f,%f",&coefp,&coefi,&coefd)>=1) datachange=true;
                    break;
                default :
                    ;
            }
        }
// envoie des data vers PC
        if (EnvoiePC!=0) {
            switch (EnvoiePC) {
                case 'V' : // angle mesure
                    PC.printf("$V,%0.1f,%0.1f\r\n",VitFluxAir,Frequencehelice);
                    EnvoiePC=0;
                    break;
                default :
                    EnvoiePC=0;
            }
        }
        if (datachange) {
            led_green = !led_green;
            Ecran();
            datachange = false;
        }
    }
}

