/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Adafruit_SSD1306.h"
#include "ADS1115.h"


#define BLINKING_RATE_MS   3000

#define MAX_P   180
#define MIN_P   50


//ADC
I2C i2c_ADC(D12, A6);
InterruptIn ADC_rdy(D9);
char adc_flg;

//OLED
I2C i2c_oled(D4, D5);
Adafruit_SSD1306_I2c myOled(i2c_oled,A1,0x78,64,128);

//UART
Serial pc(USBTX, USBRX, 115200);

//MOTOR
DigitalOut motor_in1(D10);
DigitalOut motor_in2(D2);

//VALVE
PwmOut valve_in1(D3);
DigitalOut valve_in2(D6);

//state
int state;

void OLED_TEST2(double x);
void adc_flip();
double ADC_func();
void MOTOR_On(void);
void MOTOR_Off(void);
void VALVE_On(void);
void VALVE_Off(void);
void VALVE_pwm(void);

int main()
{
    double data=0;
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    
    //ADS Init
    ADS1115_Init(&i2c_ADC, ADS1115_ADDRESS);
    ADS1115_setConti_ADC_SingleEnded(0);
    
    adc_flg = 0;
    ADC_rdy.mode(PullUp);
    ADC_rdy.fall(&adc_flip);    
    
    //OLED
    myOled.clearDisplay();
    myOled.setTextCursor(0,0);
    myOled.printf("NIBP Start...\r\n");
    myOled.display();   
    
    //Motor & Valve init
    MOTOR_Off();
    VALVE_Off();
    
    state = 0;

    while (true) {
        led = !led;
        if (adc_flg == 1) data = ADC_func();
        //OLED_TEST2(data);
    }
}


void OLED_TEST2(double x)
{
    myOled.clearDisplay();
    myOled.setTextCursor(0,0);
    myOled.printf("map : %f\r\n", x);
    myOled.display();   
}


void adc_flip()
{
    adc_flg = 1;
}

double ADC_func()
{
    int adc_data;
    double volt;
    double pressure;
    static double mcp=0;
    
    adc_flg = 0;
    adc_data = ADS1115_getConti_ADC_SingleEnded();
    volt = (double)adc_data*1875/10000000;
    pressure = (volt-0.5)*10*7.50062;
    
    mcp = 0.9*mcp + 0.1*pressure;
    
    //pc.printf("%d, %f, %f\n", adc_data, volt, pressure); // print reading
    
    if (state == 1)
        pc.printf("%d,%f,%f,%f\n", adc_data, volt, pressure, mcp);
    if(state == 0){
        if(mcp < MAX_P){
            VALVE_On();
            MOTOR_On();    
        }
        else{
            MOTOR_Off();
            VALVE_pwm();
            state = 1;
        }
    }
    else if(state == 1){
        if(mcp < MIN_P){
            state = 2;
            VALVE_Off();
            myOled.printf("END\r\n");
            myOled.display();   
        }
    }     
    return mcp;
}

void MOTOR_On(void)
{
    motor_in1 = 1;
    motor_in2 = 0;
}
void MOTOR_Off(void)
{
    motor_in1 = 0;
    motor_in2 = 0;
}

void VALVE_On(void)
{
    valve_in1 = 1;
    valve_in2 = 0;
}

void VALVE_Off(void)
{
    valve_in1 = 0;
    valve_in2 = 0;
}

void VALVE_pwm(void)
{
    valve_in1.period(0.001f);
    valve_in1.write(0.6f);
    valve_in2 = 0;
}