#ifndef USBHOSTMOUSEKEYBOARD_H_INCLUDED
#define USBHOSTMOUSEKEYBOARD_H_INCLUDED

#include "USBHostConf.h"

#if USBHOST_MOUSE_KEYBOARD

#include "USBHost.h"

#define REPORT_ID_IDLE 0
#define REPORT_ID_KEYBOARD 1
#define REPORT_ID_MOUSE 2
#define REPORT_ID_VOLUME 3


/**
 * A class to communicate a USB mouse
 */
class USBHostMouseKb : public IUSBEnumerator {
public:

    /**
    * Constructor
    */
    USBHostMouseKb(int Interface);

    /**
     * Try to connect a mouse device
     *
     * @return true if connection was successful
     */
    bool connect();

    /**
    * Check if a mouse is connected
    *
    * @returns true if a mouse is connected
    */
    bool connected();

    void poll();

    /**
     * Attach a callback called when a mouse event is received
     *
     * @param ptr function pointer
     */
    inline void attachMouseEvent(void (*ptr)(uint8_t buttons, int8_t x, int8_t y, int8_t z)) {
        if (ptr != NULL) {
            onUpdate = ptr;
        }
    }

    /**
     * Attach a callback called when the button state changes
     *
     * @param ptr function pointer
     */
    inline void attachButtonEvent(void (*ptr)(uint8_t buttons)) {
        if (ptr != NULL) {
            onButtonUpdate = ptr;
        }
    }

    /**
     * Attach a callback called when the X axis value changes
     *
     * @param ptr function pointer
     */
    inline void attachXEvent(void (*ptr)(int8_t x)) {
        if (ptr != NULL) {
            onXUpdate = ptr;
        }
    }

    /**
     * Attach a callback called when the Y axis value changes
     *
     * @param ptr function pointer
     */
    inline void attachYEvent(void (*ptr)(int8_t y)) {
        if (ptr != NULL) {
            onYUpdate = ptr;
        }
    }

    /**
     * Attach a callback called when the Z axis value changes (scrolling)
     *
     * @param ptr function pointer
     */
    inline void attachZEvent(void (*ptr)(int8_t z)) {
        if (ptr != NULL) {
            onZUpdate = ptr;
        }
    }

    /**
     * Attach a callback called when a keyboard event is received
     *
     * @param ptr function pointer
     */

    inline void attachKb(void (*ptr)(uint8_t key)) {
        if (ptr != NULL) {
            onKey = ptr;
        }
    }

    /**
     * Attach a callback called when a keyboard event is received
     *
     * @param ptr function pointer
     */
    inline void attachKb(void (*ptr)(uint8_t keyCode, uint8_t modifier)) {
        if (ptr != NULL) {
            onKeyCode = ptr;
        }
    }

protected:
    //From IUSBEnumerator
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); //Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); //Must return true if the endpoint will be used

private:
    USBHost * host;
    USBDeviceConnected * dev;
    USBEndpoint * int_in_mouse;
    USBEndpoint * int_in_kb;
    uint8_t report[20];
    bool dev_connected;
    bool mouse_device_found;
    bool kb_device_found;
    int mouse_intf;
    int kb_intf;

    uint8_t buttons;
    int8_t x;
    int8_t y;
    int8_t z;

    void rxHandlerMouse();
    void rxHandlerKb();
    void (*onUpdate)(uint8_t buttons, int8_t x, int8_t y, int8_t z);
    void (*onButtonUpdate)(uint8_t buttons);
    void (*onXUpdate)(int8_t x);
    void (*onYUpdate)(int8_t y);
    void (*onZUpdate)(int8_t z);
    void (*onKey)(uint8_t key);
    void (*onKeyCode)(uint8_t key, uint8_t modifier);

    int report_id;
    void init();
};

#endif


#endif /* USBHOSTMOUSEKEYBOARD_H_INCLUDED */
