/* mbed USBHost Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "USBHostMouseKeyboard.h"

#if  USBHOST_MOUSE_KEYBOARD

//#define Keyb_German 1

#ifdef Keyb_German
static uint8_t keymap[4][0x39] = {
    { 0, 0, 0, 0, 'a', 'b' ,
      'c', 'd', 'e', 'f', 'g' ,
      'h', 'i', 'j', 'k', 'l',
      'm', 'n', 'o', 'p', 'q',
      'r', 's', 't', 'u', 'v',
      'w', 'x', 'y', 'z', '1',
      '2', '3', '4', '5', '6',
      '7', '8', '9', '0', 0x0A /*enter*/,
      0x1B /*escape*/, 0x08 /*backspace*/, 0x09/*tab*/, 0x20/*space*/, 'ß',
      '´', 'ü', '+', '<', '#',
      'ö', 'ä', 0, ',', '.',
      '-'},

    /* CTRL MODIFIER */
    { 0, 0, 0, 0, 0, 0 /*0x05*/,
      0, 0, 0, 0, 0 /*0x0a*/,
      0, 0, 0, 0, 0/*0x0f*/,
      0, 0, 0, 0, 0/*0x14*/,
      0, 0, 0, 0, 0/*0x19*/,
      0, 0, 0, 0, 0/*0x1E*/,
      0, 0, 0, 0, 0/*0x23*/,
      0, 0, 0, 0, 0 /*enter*/, /*0x28*/
      0, 0, 0, 0, 0, /*0x2d*/
      0, 0, 0, 0, 0, /*0x32*/
      0, 0, 0, 0, 0, /*0x37*/
      0},

    /* SHIFT MODIFIER */
    { 0, 0, 0, 0, 'A', 'B' /*0x05*/,
      'C', 'D', 'E', 'F', 'G' /*0x0a*/,
      'H', 'I', 'J', 'K', 'L'/*0x0f*/,
      'M', 'N', 'O', 'P', 'Q'/*0x14*/,
      'R', 'S', 'T', 'U', 'V'/*0x19*/,
      'W', 'X', 'Y', 'Z', '!'/*0x1E*/,
      '"', '§', '$', '%', '&'/*0x23*/,
      '/', '(', ')', '=', 0, /*0x28*/
      0, 0, 0, 0, '?', /*0x2d*/
      '`', 'Ü', '*', '>', '\'', /*0x32*/
      'Ö', 'Ä', 0, ';', ':', /*0x37*/
      '_'},

    /* ALT MODIFIER */
    { 0, 0, 0, 0, 0, 0 /*0x05*/,
      0, 0, 0, 0, 0 /*0x0a*/,
      0, 0, 0, 0, 0/*0x0f*/,
      'µ', 0, 0, 0, '@'/*0x14*/,
      0, 0, 0, 0, 0/*0x19*/,
      0, 0, 0, 0, 0/*0x1E*/,
      '²','³', 0, 0, 0/*0x23*/,
      '{', '[', ']', '}', 0 /*enter*/, /*0x28*/
      '\'', 0, 0, 0, '\\', /*0x2d*/
      0, 0, '~', '|', 0, /*0x32*/
      0, 0, 0, 0, 0, /*0x37*/
      0}

};
#else
static uint8_t keymap[4][0x39] = {
    { 0, 0, 0, 0, 'a', 'b' /*0x05*/,
      'c', 'd', 'e', 'f', 'g' /*0x0a*/,
      'h', 'i', 'j', 'k', 'l'/*0x0f*/,
      'm', 'n', 'o', 'p', 'q'/*0x14*/,
      'r', 's', 't', 'u', 'v'/*0x19*/,
      'w', 'x', 'y', 'z', '1'/*0x1E*/,
      '2', '3', '4', '5', '6'/*0x23*/,
      '7', '8', '9', '0', 0x0A /*enter*/, /*0x28*/
      0x1B /*escape*/, 0x08 /*backspace*/, 0x09/*tab*/, 0x20/*space*/, '-', /*0x2d*/
      '=', '[', ']', '\\', '#', /*0x32*/
      ';', '\'', 0, ',', '.', /*0x37*/
      '/'},

    /* CTRL MODIFIER */
    { 0, 0, 0, 0, 0, 0 /*0x05*/,
      0, 0, 0, 0, 0 /*0x0a*/,
      0, 0, 0, 0, 0/*0x0f*/,
      0, 0, 0, 0, 0/*0x14*/,
      0, 0, 0, 0, 0/*0x19*/,
      0, 0, 0, 0, 0/*0x1E*/,
      0, 0, 0, 0, 0/*0x23*/,
      0, 0, 0, 0, 0 /*enter*/, /*0x28*/
      0, 0, 0, 0, 0, /*0x2d*/
      0, 0, 0, 0, 0, /*0x32*/
      0, 0, 0, 0, 0, /*0x37*/
      0},

    /* SHIFT MODIFIER */
    { 0, 0, 0, 0, 'A', 'B' /*0x05*/,
      'C', 'D', 'E', 'F', 'G' /*0x0a*/,
      'H', 'I', 'J', 'K', 'L'/*0x0f*/,
      'M', 'N', 'O', 'P', 'Q'/*0x14*/,
      'R', 'S', 'T', 'U', 'V'/*0x19*/,
      'W', 'X', 'Y', 'Z', '!'/*0x1E*/,
      '@', '#', '$', '%', '^'/*0x23*/,
      '&', '*', '(', ')', 0, /*0x28*/
      0, 0, 0, 0, 0, /*0x2d*/
      '+', '{', '}', '|', '~', /*0x32*/
      ':', '"', 0, '<', '>', /*0x37*/
      '?'},

    /* ALT MODIFIER */
    { 0, 0, 0, 0, 0, 0 /*0x05*/,
      0, 0, 0, 0, 0 /*0x0a*/,
      0, 0, 0, 0, 0/*0x0f*/,
      0, 0, 0, 0, 0/*0x14*/,
      0, 0, 0, 0, 0/*0x19*/,
      0, 0, 0, 0, 0/*0x1E*/,
      0, 0, 0, 0, 0/*0x23*/,
      0, 0, 0, 0, 0 /*enter*/, /*0x28*/
      0, 0, 0, 0, 0, /*0x2d*/
      0, 0, 0, 0, 0, /*0x32*/
      0, 0, 0, 0, 0, /*0x37*/
      0}

};
#endif

USBHostMouseKb::USBHostMouseKb(int Interface) {
    host = USBHost::getHostInst(Interface);
    init();
}


void USBHostMouseKb::init() {
    dev = NULL;
    int_in_mouse = NULL;
    int_in_kb=NULL;
    report_id = 0;
    onUpdate = NULL;
    onButtonUpdate = NULL;
    onXUpdate = NULL;
    onYUpdate = NULL;
    onZUpdate = NULL;
    onKey = NULL;
    onKeyCode = NULL;
    dev_connected = false;
    mouse_intf = -1;
    kb_intf=-1;
    mouse_device_found = false;
    kb_device_found = false;
}

bool USBHostMouseKb::connected() {
    return dev_connected;
}

void USBHostMouseKb::poll() {
host->poll();
}

bool USBHostMouseKb::connect() {

    if (dev_connected) {
        return true;
    }

    for (uint8_t i = 0; i < MAX_DEVICE_CONNECTED; i++) {
        if ((dev = host->getDevice(i)) != NULL) {

            if (host->enumerate(dev, this))
                break;

            if ((mouse_device_found)&&(mouse_intf>-1)) {

            int_in_mouse = dev->getEndpoint(mouse_intf, INTERRUPT_ENDPOINT, IN);
            if (!int_in_mouse)
                    return false;
            USB_INFO("New Mouse - device: VID:%04x PID:%04x [dev: %p - intf: %d]", dev->getVid(), dev->getPid(), dev, mouse_intf);
            dev->setName("Mouse", mouse_intf);
            host->registerDriver(dev, mouse_intf, this, &USBHostMouseKb::init);
            int_in_mouse->attach(this, &USBHostMouseKb::rxHandlerMouse);
            host->interruptRead(dev, int_in_mouse, report, int_in_mouse->getSize(), false);
            dev_connected = true;
            }

            if ((kb_device_found)&&(kb_intf>-1)) {
            int_in_kb = dev->getEndpoint(kb_intf, INTERRUPT_ENDPOINT, IN);
            if (!int_in_kb)
                    return false;
            USB_INFO("New Keyboard - device: VID:%04x PID:%04x [dev: %p - intf: %d]", dev->getVid(), dev->getPid(), dev, kb_intf);
            dev->setName("Keyboard", kb_intf);
            host->registerDriver(dev, kb_intf, this, &USBHostMouseKb::init);
            int_in_kb->attach(this, &USBHostMouseKb::rxHandlerKb);
            host->interruptRead(dev, int_in_kb, report, int_in_kb->getSize(), false);
            dev_connected = true;
            }
            if (dev_connected == true)return true;
        }
    }
    return false;
}

void USBHostMouseKb::rxHandlerMouse() {
    int len = int_in_mouse->getLengthTransferred();
    int len_listen = int_in_mouse->getSize();
    if (!((report[0]==0)&(report[1]==0)&(report[2]==0)&(report[3]==0)&(report[4]==0)&(report[5]==0)&(report[6]==0)&(report[7]==0)&(report[8]==0)))
        USB_INFO("RepMouse %d :%d :%d :%d :%d :%d :%d :%d :%d\r\n",report[0],report[1],report[2],report[3],report[4],report[5],report[6],report[7],report[8]);

    if (len<8)
    {
    if (onUpdate) {
        (*onUpdate)(report[0] & 0x07, report[1], report[2], report[3]);
    }

    if (onButtonUpdate && (buttons != (report[0] & 0x07))) {
        (*onButtonUpdate)(report[0] & 0x07);
    }

    if (onXUpdate && (x != report[1])) {
        (*onXUpdate)(report[1]);
    }

    if (onYUpdate && (y != report[2])) {
        (*onYUpdate)(report[2]);
    }

    if (onZUpdate && (z != report[3])) {
        (*onZUpdate)(report[3]);
    }

    // update mouse state
    buttons = report[0] & 0x07;
    x = report[1];
    y = report[2];
    z = report[3];

    if (dev)
        host->interruptRead(dev, int_in_mouse, report, len_listen, false);
        return;
    }

    if(report[0]==REPORT_ID_IDLE )
    {
     if (dev)
        host->interruptRead(dev, int_in_mouse, report, len_listen, false);
    }

    if(report[0]==REPORT_ID_MOUSE )
    {
    if (onUpdate) {
        (*onUpdate)(report[1] & 0x07, report[3], report[4], report[5]);
    }

    if (onButtonUpdate && (buttons != (report[1] & 0x07))) {
        (*onButtonUpdate)(report[1] & 0x07);
    }

    if (onXUpdate && (x != report[3])) {
        (*onXUpdate)(report[3]);
    }

    if (onYUpdate && (y != report[4])) {
        (*onYUpdate)(report[4]);
    }

    if (onZUpdate && (z != report[5])) {
        (*onZUpdate)(report[5]);
    }

    // update mouse state
    buttons = report[1] & 0x07;
    x = report[3];
    y = report[4];
    z = report[5];

    if (dev)
        host->interruptRead(dev, int_in_mouse, report, len_listen, false);
    }
}

void USBHostMouseKb::rxHandlerKb() {
    uint8_t key = 0;
    int len = int_in_kb->getLengthTransferred();
    int index = (len == 9) ? 1 : 0;
    int len_listen = int_in_kb->getSize();
    if (!((report[0]==0)&(report[1]==0)&(report[2]==0)&(report[3]==0)&(report[4]==0)&(report[5]==0)&(report[6]==0)&(report[7]==0)&(report[8]==0)))
        USB_INFO("RepKb %d :%d :%d :%d :%d :%d :%d :%d :%d\r\n",report[0],report[1],report[2],report[3],report[4],report[5],report[6],report[7],report[8]);
    if(report[0]==REPORT_ID_IDLE )
    {
     if (dev)
        host->interruptRead(dev, int_in_kb, report, len_listen, false);
    }
    if ((dev->getVid()==1133)&&(dev->getPid()==50475))
    {
      uint8_t modifier=report[0];
      if (report[7]!=0)
      {
        USB_INFO("RepKb  :0x%x\r\n",report[7]);
        if ((modifier==64)||(modifier==4))modifier=3;
        if(report[7]==0x64)report[7]=0x31;
        key = keymap[modifier][report[7]];
        if (key && onKey) {
            (*onKey)(key);
        }
        if ((report[7] || modifier) && onKeyCode) {
            (*onKeyCode)(report[7], modifier);
        }
      }
    }
    else
    {
    if (len == 8 || len == 9) {
        uint8_t modifier = (report[index] == 4) ? 3 : report[index];
        len_listen = len;
        key = keymap[modifier][report[index + 2]];
        if (key && onKey) {
            (*onKey)(key);
        }
        if ((report[index + 2] || modifier) && onKeyCode) {
            (*onKeyCode)(report[index + 2], modifier);
        }
    }
    }
    if (dev && int_in_kb)
        host->interruptRead(dev, int_in_kb, report, len_listen, false);
}

/*virtual*/ void USBHostMouseKb::setVidPid(uint16_t vid, uint16_t pid)
{
    // we don't check VID/PID for keyboard driver
}

/*virtual*/ bool USBHostMouseKb::parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol) //Must return true if the interface should be parsed
{
    if ((mouse_intf == -1) &&
        (intf_class == HID_CLASS) &&
        (intf_subclass == 0x01) &&
        (intf_protocol == 0x02)) {
        mouse_intf = intf_nb;
        return true;
    }
    if ((kb_intf == -1) &&
        (intf_class == HID_CLASS) &&
        (intf_subclass == 0x01) &&
        (intf_protocol == 0x01)) {
        kb_intf = intf_nb;
        return true;
    }
    return false;
}

/*virtual*/ bool USBHostMouseKb::useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir) //Must return true if the endpoint will be used
{
    if (intf_nb == mouse_intf) {
        if (type == INTERRUPT_ENDPOINT && dir == IN) {
            mouse_device_found = true;
            return true;
        }
    }
    if (intf_nb == kb_intf) {
        if (type == INTERRUPT_ENDPOINT && dir == IN) {
            kb_device_found = true;
            return true;
        }
    }
    return false;
}

#endif
