#include "mbed.h"
#include "rtos.h"
#include "USBHostMouseKeyboard.h"
#include "USBHostMSD.h"
#include "LCD_DISCO_F746NG.h"
#include "F746_GUI.hpp"
#include "SAI_InOut.hpp"

using namespace Mikami;


LCD_DISCO_F746NG lcd;
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
Thread read_adc;
Thread thread2;
const int FS = I2S_AUDIOFREQ_16K;   //　16 kHz

int data_length;        //  length of adc_data
Array<float> adc_data(513);   // data - read from mic .. write to usb-stick
Mutex data_mutex; 

#define FastSpeedInterface 0
#define HighSpeedInterface 1

void usb_task(void const *) {

    USBHostMSD msd("usb",HighSpeedInterface);
//    USBHostMSD msd("usb",FastSpeedInterface);

    int i = 0;
    int res;
    int error=0,nBlocksWritten ;
    char buf[50], buf2[50];
    while(1) {
            lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"USB connect", CENTER_MODE);

        // try to connect a MSD device
        while(!msd.connect()) {
            lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"USB Waiting", CENTER_MODE);

            Thread::wait(500);
            printf("waiting\n");
        }
  
               wait_ms(500);
                msd.mount() ;
               wait_ms(500);
            
             
         // open a file
            srand(time(NULL));
            sprintf(buf2,"/usb/test%i.txt\0", rand()%4);
            FILE * fp = fopen(buf2, "w");
            lcd.DisplayStringAt(0, LINE(11), (uint8_t *)buf2, CENTER_MODE);
        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        
        
        while(1) {

  

            if (fp != NULL) {
                i++;

              data_mutex.lock(); 
              
                 sprintf(buf, "Vor dem fwrite %i length %i    \0", i, data_length);
                 lcd.DisplayStringAt(0, LINE(4), (uint8_t *)buf, CENTER_MODE);

               // Write the data block
                nBlocksWritten = fwrite(
                                adc_data,               // const void *ptr
                                2,         // size_t size 2byte=float
                                data_length,   // size_t nmemb
                                fp               // FILE *stream
                                );
                              //  fflush(fp);

                data_length = 0;
            

                sprintf(buf, "Nach fwrite %i length %i \0",i, nBlocksWritten);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)buf, CENTER_MODE);
 
               Thread::wait(100);

               data_mutex.unlock();
     /*
                if (error==1)
                {
                sprintf(buf,"Goodbye New World!\r\n");
                lcd.DisplayStringAt(0, LINE(7), (uint8_t *)buf, CENTER_MODE);

                error=0;
                }
                fclose(fp);
    */
     /*           if(res<0)
                {
                   sprintf(buf,"FILE write ERROR\r\n");
                lcd.DisplayStringAt(0, LINE(7), (uint8_t *)buf, CENTER_MODE);

                   msd.unmount();
                   wait_ms(5000);
                   msd.mount() ;
                   error=1;
                }
*/
            } else {
                
 /*
                sprintf(buf, "FILE == NULL\r\n");
                lcd.DisplayStringAt(0, LINE(7), (uint8_t *)buf, CENTER_MODE);

                msd.unmount();
                wait_ms(5000);
                msd.mount() ;
                error=1;
   */
            }

            Thread::wait(500);

            // if device disconnected, try to connect again
            if (!msd.connected())
                break;
        }  

      
    } 
}


 
void adc_thread() {
    int i=0;
    char buf[50];
         
          
    lcd.SetTextColor(LCD_COLOR_WHITE);
    
    SaiIO mySai(SaiIO::INPUT, 512+1, FS,
                INPUT_DEVICE_DIGITAL_MICROPHONE_2);
                Thread::wait(1000);
                int16_t xLn, xRn;
                mySai.Input(xLn, xRn); // haengt wenn ich das nicht mache  .. warum ??
                   

    while (1) {
        data_mutex.lock();        

         i++;
         
        sprintf(buf,"adc_read .. vor read %i",i);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)buf, CENTER_MODE);       

            data_length = mySai.GetLength();
 
               for (int n=0; n<data_length; n++)
                {
                    int16_t xL, xR;
                    mySai.Input(xL, xR);
                    adc_data[n] = (float)xL;
                   
         sprintf(buf,"adc_read .. nach read %i length %i",n, data_length);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)buf, CENTER_MODE);


                }
                mySai.ResetCaptured();
 
    
         sprintf(buf,"adc_read .. nach read %i length %i",i, data_length);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)buf, CENTER_MODE);
        Thread::wait(100);
        data_mutex.unlock();     

    }
}
 
 void led2_thread2() {
    int i=0;
    char buf[50];
          lcd.SetTextColor(LCD_COLOR_WHITE);

    while (true) {
        sprintf(buf,"In der Thread2 %i",i++);
        led2 = !led2;
      //  lcd.Clear(LCD_COLOR_GREEN);
    //    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)buf, CENTER_MODE);
        Thread::wait(100);
        
    }
}
int main() {
     int i=0;
    char buf[50];
    
    read_adc.start(adc_thread); 
    thread2.start(led2_thread2);
   
   // thread2.set_priority(osPriorityNormal);
    
    Thread msdTask(usb_task, NULL, osPriorityNormal, 1024 * 4);
    
     lcd.Clear(LCD_COLOR_BLACK);
     lcd.SetBackColor(LCD_COLOR_BLACK);
     lcd.SetTextColor(LCD_COLOR_WHITE);
     ButtonGroup bG(400, 200, 50, 30, 2, (string[]){"ON", "OFF"}, 0, 5, 1, 0);
 
    while (true) {

      wait(0.3);
      sprintf(buf,"In Main %i",i++);
       int num;
       if (bG.GetTouchedNumber(num)) sprintf(buf,"ist on");
     lcd.SetBackColor(LCD_COLOR_BLACK);

      lcd.DisplayStringAt(0, LINE(9), (uint8_t *)buf, CENTER_MODE);
      wait(.1);

     if(!num) {
 
         }
      
    }
}
