/*
Hardware: Nucleo F103RB
Test02 analog ein über RS232 aus mit 9600Baud
Ziel: Verschiedene Analogwerte einlesen
Aufgaben: Pinbezeichnungen testen
Konkret: Eine zweite und dritte externe LED hinzufügen. Funktion:
LED1 leuchtet zwischen 1,6Volt und 2,2Volt;  LED2 leuchtet unterhalb 1,6V; LED3 leuchtet oberhalb 2,2V
Aug 2015
*/

#include "mbed.h"

AnalogIn analog_value0(A0);      //Entspricht Pin PA_0
DigitalOut led(LED1);   //LED1 auf der Platine vom Nucleo-Board
DigitalOut led2(D7);   //D7 auf ARDUINO Steckleite = PA_8
DigitalOut led3(D6);   //D6 auf ARDUINO Steckleite = PB_10

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
// fprint kann ohne z.B.: Serial pc(USBTX, USBRX); // tx, rx über USB-Chip
// dann jedoch nur mit 9600 BAUD
// ansonsten z.B.: pc.baud(19200);
//------------------------------------

int main()
{

    float mess0;

    printf("\nAnalogIn example\n");

    while(1) {
        mess0 = analog_value0.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        mess0 = mess0 * 3300; // Change the value to be in the 0 to 3300 range -> milliVolt
        printf("Analogwert0 = %.2f mVolt\r\n", mess0);  //Rs232 output-> You will see this in Terminalprogramm on PC
        //%.2f -> Anzeige mit 2Stellen hinter Komma
        //\r = Wagenruecklauf  \n =neue Zeile

        if ((mess0 > 1599 && mess0 < 2201)) { // If the value is greater than 1,6V and smaller 2,2V  then switch the LED off
            led = 1;
        } else {
            led = 0;
        }
        if (mess0 < 1600 ) { // If the value is greater than 1,6V then switch the LED on
            led2 = 1;
        } else {
            led2 = 0;
        }
        if (mess0 >2200 ) { // If the value is greater than 2,2V then switch the LED on
            led3 = 1;
        } else {
            led3 = 0;
        }

        wait(0.5); // 500 ms
    }
}
