
/*
LM35 und Bluetooth
Beispiel zur Temperaturmessung mit LM35 und Bluetooth
Für die serielle Kommunikation mit Bluetooth werden die 
pins PC_10 und PC_11 benutzt. Dort das Bluetooth Modul HC06 einstecken
TxD und RxD werden gedreht. Das Modul erhält +5V als VCC. RxD und TxD 
direkt anschliessen -> 3,3V bis 5V tolerant.
Über die USB Verbindung wird eine virtuelle COM zum PC aufgebaut, 9600Baud
Diese Verbindung wird für Profilab benutzt.
G. Neumaier J.Schnaiter Gewerblich-Technische Schule Offenburg Jan2018
===========================================================
*/
// 04u_ADC-Bluetooth
#include "mbed.h"
#define ANZAHL 10

Serial pc(SERIAL_TX, SERIAL_RX);
Serial blue(PC_10, PC_11); // TX,RX
AnalogIn lm35(A0);

int main()
{

    float tempC,a[ANZAHL],avg;
    int tempBlue;
    while(1) {
        for(int i=0; i<ANZAHL; i++) {
            // gemessen wird zwischen 0 und 1
            a[i]=lm35.read();
            wait(.02);
        }
        avg=0;
        for(int i=0; i<ANZAHL; i++) {
            avg=avg+a[i];
        }
        avg=avg/ANZAHL;

        // lm35 liefert 10mV pro °C
        // 20mV -> 20°C
        tempC=(avg*3.3*100.0); // 3,3V sowie 10mV * 100
        //AD-Wandler liefert 0.000 ...1.000 (3,3V)
        //max Werte: 0,000 bis 333.000 
        //pc.printf("%1.3f\n",tempC);
        tempBlue = (int) tempC;
        
        
        // Keuwl kann nur positive Werte 0 ...255 0=0Grad; 20=0Grad 80= 80Grad
        blue.printf("*T%d",tempBlue);
        
     //An PC mit Profilab   
    pc.printf("%1.3f",tempC);  //%1.3f eine Stelle vor dem Komma 3 Stellen danach float Variable
    pc.putc(10);   //10 =0x0A Steuerzeichen neue Zeile
    pc.printf("%u",150);  //u ist unsigned integer Dummy könnte für Ausgabe 8 bit (z.B. 8pins) benutzt werden
    pc.putc(10);   //10 =0x0A Steuerzeichen neue Zeile  
    pc.putc(13);//13 =0x0D Steuerzeichen Wagenruecklauf (an Anfang der Zeile)
        
        wait_ms(500); //500msec
        //wait(1); //1sec
    }
}


