/*
Data send to IIC-board with PCF8574a IC
Data comming from analog-value Pin A0 = PA_0 Nucleo-board
you see a digital 8bit counter as a result
Aug. 2015 G. Neumaier Gewerblich-Technische Schule Offenburg Germany
*/

#include "mbed.h"
#define PCF8574a_ADDR  0x72 // PCF8574a address IIC-board Birk 

I2C i2c(I2C_SDA, I2C_SCL); //IIC Pins SDA and SCL for ARDUINO pinheader Nucleo-board
            //SCL and SPA pullup resistors 2k2Ohm to+5Volt
DigitalOut myled(LED1); //LED on Nucleo-board
AnalogIn analog_value0(A0);      //same as Pin PA_0 
Serial pc(SERIAL_TX, SERIAL_RX);
 
int main()
{
    float mess0;
    unsigned char mess1;
    char data_write[2]; //must be char!!
 //   char data_read[2]; //read buffer
    data_write[0] = 0xf2; //LEDs low aktiv  dummy
    int status = i2c.write(PCF8574a_ADDR , data_write, 1, 0);
    if (status != 0) // Error  no acknowledge detected 
    { 
        while (1) //-> endless loop when error no IIC-IC detected
        {   
        myled = !myled;
        wait(0.7);
        }
    }
 
    while (1) //endless loop
        {
        mess0 = analog_value0.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        mess0 = mess0 * 255; // Change the value to be in the 0 to 255 range -> 8bit
        mess1 = (char) mess0;  //type converting from float to char(8bit)
        printf("Analogvalue0 = %.1f \r\n", mess0);  //Rs232 output-> You will see this in terminalprogram on PC
        //%.1f -> display 1 digit after comma
        // 
        data_write[0] = ~mess1; //8bit analog-value  ~ inverted  leds lowaktiv!!
        i2c.write(PCF8574a_ADDR , data_write, 1, 1); // no stop 
        //you see a digital 8bit counter at leds contacted to IC PCF8574
    }
 
}
 
