#include "MicroBit.h" 
int pLocationX;
int pLocationY;
int xPos = 2;
bool gameOver = false;
int y;
int obstacleX;
int score = 0;
int playX;
int direction = 0;
MicroBit uBit;

//Gets X value from microbit
void getXPos(){
    playX = uBit.accelerometer.getX();
    if(playX > 250){
        xPos++;
        direction = 1;
    }else if (playX < -250) {
        xPos--;
        direction = 0;
    }
    
}

//Compares player location with obstacle location to check collision.    
void checkCollision(){
    if (xPos == obstacleX || xPos == obstacleX - 1 && y == 4){
        gameOver = true;    
    }else{
            
        gameOver = false;
        }
        
}

//Draws the player on screen, and ensures it cannot go off the side. Also clears lEDs as it moves.
void displayPlayerLocation(){
    getXPos();
    if (xPos < 0){
        xPos = 0;
    } else if(xPos > 4) {
        xPos = 4;
    } 
    if(direction == 1) {
        uBit.display.image.setPixelValue(xPos - 1, 4, 0);
    } else if(direction == 0) {
        uBit.display.image.setPixelValue(xPos + 1, 4, 0);
    }
    
    checkCollision();
    uBit.display.image.setPixelValue(xPos, 4, 255);
}

//Displays the falling leds, and also clears them afterwards
void displayObs(){
    uBit.display.image.setPixelValue(obstacleX, y, 0);
    obstacleX = uBit.random(5);

    for (y = 0; y  < 5; y++){ // descends the obstacles based on y value
        uBit.display.image.setPixelValue(obstacleX, y, 255);
        if (obstacleX > 0)
        {
            uBit.display.image.setPixelValue(obstacleX - 1, y, 255); 
        }
        if (y > 0)
        {
            uBit.display.image.setPixelValue(obstacleX, y - 1, 0);
        }
        if (obstacleX > 0 && y > 0)
        {
            uBit.display.image.setPixelValue(obstacleX - 1, y - 1, 0);
        }
        if (score > 0)
        {
            uBit.sleep(500 - score);
        }else if (score >= 500)
        {
            uBit.sleep(0);
        }else{
            uBit.sleep(500);
        }
        checkCollision();
        displayPlayerLocation();
    }
    y = 4;
    uBit.display.image.setPixelValue(obstacleX, y, 0);
    uBit.display.image.setPixelValue(obstacleX - 1, y, 0);    
    score += 5;
}




int main(){
    uBit.init();
    while(gameOver == false){
        displayObs();
    }
    uBit.display.scroll("Game Over, Score: ");
    uBit.display.scroll(score);
}



