/*  
      This file is part of Smoothie (http://smoothieware.org/). The motion control part is heavily based on Grbl (https://github.com/simen/grbl).
      Smoothie is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
      Smoothie is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
      You should have received a copy of the GNU General Public License along with Smoothie. If not, see <http://www.gnu.org/licenses/>. 
*/

#include "libs/Module.h"
#include "libs/Kernel.h"
#include "modules/communication/utils/Gcode.h"
#include "modules/robot/Stepper.h"
#include "Spindle.h"
#include "libs/nuts_bolts.h"

Spindle::Spindle(){

}

void Spindle::on_module_loaded() {
    if( !this->kernel->config->value( spindle_module_enable_checksum )->by_default(false)->as_bool() ){ return; } 

    // Settings
    this->on_config_reload(this);
    
    this->register_for_event(ON_GCODE_EXECUTE);
    this->register_for_event(ON_PLAY);
    this->register_for_event(ON_PAUSE);
    this->register_for_event(ON_BLOCK_BEGIN);
    this->register_for_event(ON_BLOCK_END);
}


// Get config
void Spindle::on_config_reload(void* argument){
    this->spindle_pin= this->kernel->config->value(spindle_pin_checksum)->by_default("0.4" )->as_pin()->as_output();
}

// Turn spindle off spindle at the end of a move
void  Spindle::on_block_end(void* argument){
    //this->spindle_pin->set(0);
}

// Set spindle power at the beginning of a block
void Spindle::on_block_begin(void* argument){
    //this->set_spindle();
}

// When the play/pause button is set to pause, or a module calls the ON_PAUSE event
void Spindle::on_pause(void* argument){
    this->spindle_pin->set(0);
}

// When the play/pause button is set to play, or a module calls the ON_PLAY event
void Spindle::on_play(void* argument){
    this->set_spindle();
}

// Turn spindle on/off depending on received GCodes
void Spindle::on_gcode_execute(void* argument){
    Gcode* gcode = static_cast<Gcode*>(argument);
    this->spindle_on = false;
    if( gcode->has_letter('G' )){
        int code = gcode->get_value('G');
        if( code == 0 ){                    // G0
            this->kernel->serial->printf("off\r\n");
            this->spindle_pin->set(0);
            this->spindle_on =  false;
        }else if( code >= 1 && code <= 3 ){ // G1, G2, G3
            this->kernel->serial->printf("on\r\n");
            this->spindle_pin->set(1);
            this->spindle_on =  true;
        }
    }
}


void Spindle::set_spindle(){
    if( this->spindle_on && this->kernel->stepper->current_block ){ 
        this->spindle_pin->set(1);
    }
}
