/*  
      This file is part of Smoothie (http://smoothieware.org/). The motion control part is heavily based on Grbl (https://github.com/simen/grbl).
      Smoothie is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
      Smoothie is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
      You should have received a copy of the GNU General Public License along with Smoothie. If not, see <http://www.gnu.org/licenses/>. 
*/

#ifndef LASER_MODULE_H
#define LASER_MODULE_H

#include "libs/Module.h"
#include "PwmOut.h" // mbed.h lib
#include "libs/Kernel.h"
#include "modules/communication/utils/Gcode.h"


#define laser_module_enable_checksum 35529 

class Laser : public Module{
    public:
        Laser(PinName pin);
        virtual void on_module_loaded();
        virtual void on_block_end(void* argument);
        virtual void on_block_begin(void* argument);
        virtual void on_play(void* argument);
        virtual void on_pause(void* argument);
        virtual void on_gcode_execute(void* argument);
        virtual void on_speed_change(void* argument);
        void set_proportional_power();

        mbed::PwmOut laser_pin;    // PWM output to regulate the laser power
        bool   laser_on;     // Laser status
};

















#endif
