#ifndef __EEPROM__H_
#define __EEPROM__H_

#include "mbed.h"

#define DS1338_ADR     0xd0
#define DS1338_BUFFER_SIZE 10


/**
 * class to use a DS1338 rtc
 */
class DS1338 {
public:
    /*
     * Constructor, initialize the ds1338 on i2c interface.
     * @param sda : sda i2c pin (PinName)
     * @param scl : scl i2c pin (PinName)
    */
    DS1338(PinName sda, PinName scl);
    /**
     * read bytes
     * @param adr the start address
     * @param count number of byte to read
     * @param data where to put the bytes
     * @return the byte
     */
    void read(unsigned char adr,unsigned char count,char * data);
    /**
     * write bytes
     * @param adr the start address
     * @param count number of byte to write
     * @param data to be written
     * @return the byte
     */
    void write(unsigned char adr,unsigned char count,char * data);
    /**
     * read the current time
     * @param x the time;
     */
    void readTime(tm * x);
    /**
     * read the current time
     * @param x the time;
     */
    void writeTime(tm * x);
private:
    I2C _i2c;
    char buffer[DS1338_BUFFER_SIZE];
};
#endif
