#ifndef RAMSTATS_H
    #define RAMSTATS_H
//http://mbed.org/forum/bugs-suggestions/topic/2322/

// important info on reducing heap useage by converting to static and const where possible
// https://mbed.org/forum/mbed/topic/2698/
// http://mbed.org/handbook/Memory-Model

// These external symbols are maintained by the linker to indicate the
// location of various regions in the device's memory.  They will be used by
// DisplayRAMBanks() to dump the size of each RAM bank to stdout.
extern unsigned int Image$$RW_IRAM1$$Base;
extern unsigned int Image$$RW_IRAM1$$ZI$$Limit;
extern unsigned int Image$$RW_IRAM2$$Base;
extern unsigned int Image$$RW_IRAM2$$ZI$$Limit;
extern unsigned int Image$$RW_IRAM3$$Base;
extern unsigned int Image$$RW_IRAM3$$ZI$$Limit;
 
void DisplayRAMBanks(char * header);

#endif //RAMSTATS_H