#include "ramstats.h"
#include "mbed.h"
#include <stdarg.h>

//extern USBSerial DebugComms;

//_sys_clock();

/*int myfprintf(FILE *stream, const char *format, const char *arg1) {
    int done;
    const char *arg;
        concat(art1
        done=fprintf(stream,format,arg);
    return done;
}*/
int myfprintf(FILE *stream, const char *format, ...) {
    va_list arg;
    int done;
    va_start (arg, format);
        done=vfprintf(stream,format,arg);
    va_end (arg);
    fprintf(stream,"\r");
    fflush(stream);
    return done;
}
// Displays the size of static allocations for each RAM bank as indicated by
// ARM linker to stdout.
//static void DisplayRAMBanks(void)
void DisplayRAMBanks(char * header)
{
//void __heapstats(int (*dprint)( void*param, char const *format,...), void* param);
    printf("\e[2J\e[1;33;44m %s",header); // clear the screen before starting
    printf("\r\n==== Heap Stats ====\r\n");
    __heapstats((__heapprt)myfprintf,stdout);
    printf("\r\n==== Heap Valid ====\r\n");
    __heapvalid((__heapprt)myfprintf,stdout, 1);
    printf("\r\n==== Current Stack Pointer ====");
        printf("====       %10x            ====\r\n\n",__current_sp());

    printf("Static RAM bank allocations\r\n");
    printf("  Main RAM = %5u  %04x\r\n", (unsigned int)&Image$$RW_IRAM1$$ZI$$Limit - (unsigned int)&Image$$RW_IRAM1$$Base, (unsigned int)&Image$$RW_IRAM1$$ZI$$Limit - (unsigned int)&Image$$RW_IRAM1$$Base);
    printf("  RAM0     = %5u  %04x\r\n", (unsigned int)&Image$$RW_IRAM2$$ZI$$Limit - (unsigned int)&Image$$RW_IRAM2$$Base, (unsigned int)&Image$$RW_IRAM2$$ZI$$Limit - (unsigned int)&Image$$RW_IRAM2$$Base);
    printf("  RAM1     = %5u  %04x\r\n", (unsigned int)&Image$$RW_IRAM3$$ZI$$Limit - (unsigned int)&Image$$RW_IRAM3$$Base, (unsigned int)&Image$$RW_IRAM3$$ZI$$Limit - (unsigned int)&Image$$RW_IRAM3$$Base);
//    printf("\r\n\nPress 'M' to resume");
    printf("\r\n\n");

}


/*
    To move a global from main RAM to the RAM0/RAM1 bank, you can declare it something like:
    __attribute((section("AHBSRAM0"),aligned)) char LargeBuffer[1024];
    __attribute((section("AHBSRAM1"),aligned)) char LargeBuffer[1024];
    char bufA[10000] __attribute__((section("AHBSRAM1")));
 
*/


// ***********************************************************************
// ***********************************************************************
// ***********************************************************************
// Examples of Alternative methods to capture and process this info....
// ***********************************************************************
// ***********************************************************************
// ***********************************************************************
// the first two are from http://developer.mbed.org/forum/mbed/topic/2702/
/*
#include <mbed.h>
#include <stdarg.h>
 
int CaptureLine(void* pBuffer, char const* pFormatString, ...)
{
    char*   pStringEnd = (char*)pBuffer + strlen((char*)pBuffer);
    va_list valist;
    
    va_start(valist, pFormatString);
    
    return vsprintf(pStringEnd, pFormatString, valist);
}
 
int main() 
{
    char OutputBuffer[256];
    
    printf("\r\nBefore malloc.\r\n");
    OutputBuffer[0] = '\0';
    __heapstats(CaptureLine, OutputBuffer);
    printf("%s", OutputBuffer);
    
    void* pvTest = malloc(1024);
    
    printf("After malloc.\r\n");
    OutputBuffer[0] = '\0';
    __heapstats(CaptureLine, OutputBuffer);
    printf("%s", OutputBuffer);
 
    free(pvTest);    
 
    printf("After free.\r\n");
    OutputBuffer[0] = '\0';
    __heapstats(CaptureLine, OutputBuffer);
    printf("%s", OutputBuffer);
    
    return 0;
}
*/

// ***********************************************************************
// ***********************************************************************
/*
#include <mbed.h>
#include <stdarg.h>
 
struct SHeapInfo
{
    const char* HighestAllocBlock;
    const char* HighestFreeBlock;
};
 
int CaptureLine(void* pvHeapInfo, char const* pFormatString, ...)
{
    static const char*  pAllocFormatString = "alloc block %p size %3lx";
    static const char*  pFreeFormatString = "free block  %p size %3lx next=%p";
    static const char*  pCompleteFormatString = "------- heap validation complete";
    SHeapInfo*          pHeapInfo = (SHeapInfo*)pvHeapInfo;
    va_list             valist;
    
    va_start(valist, pFormatString);
    
    if (pFormatString == strstr(pFormatString, pAllocFormatString))
    {
        const char* pBlock = va_arg(valist, const char*);
        unsigned long BlockSize = va_arg(valist, unsigned long);
        const char* pBlockLastByte = pBlock + BlockSize - 1;
        
        if (pBlockLastByte > pHeapInfo->HighestAllocBlock)
        {
            pHeapInfo->HighestAllocBlock = pBlockLastByte;
        }
    }
    else if (pFormatString == strstr(pFormatString, pFreeFormatString))
    {
        const char* pBlock = va_arg(valist, const char*);
        unsigned long BlockSize = va_arg(valist, unsigned long);
        const char* pBlockLastByte = pBlock + BlockSize - 1;
        
        if (pBlockLastByte > pHeapInfo->HighestFreeBlock)
        {
            pHeapInfo->HighestFreeBlock = pBlockLastByte;
        }
    }
    else if (pFormatString == strstr(pFormatString, pCompleteFormatString))
    {
        // Ignoring end of dump string.
    }
    else
    {
        // Unrecognized format string.
        printf("Unrecognized format of %s", pFormatString);
    }
 
    return 1;
}
 
void DisplayAndClearHeapInfo(SHeapInfo* pHeapInfo)
{
    printf("Highest allocated block address: %p\r\n", pHeapInfo->HighestAllocBlock);
    printf("Highest free block address: %p\r\n", pHeapInfo->HighestFreeBlock);
    
    memset(pHeapInfo, 0, sizeof(*pHeapInfo));
}
 
int main() 
{
    SHeapInfo HeapInfo = { 0, 0 };
    
    printf("\r\nBefore malloc.\r\n");
    __heapvalid(CaptureLine, &HeapInfo, 1);
    DisplayAndClearHeapInfo(&HeapInfo);
 
    void* pvTest = malloc(1024);
    
    printf("After malloc.\r\n");
    __heapvalid(CaptureLine, &HeapInfo, 1);
    DisplayAndClearHeapInfo(&HeapInfo);
 
    free(pvTest);    
 
    printf("After free.\r\n");
    __heapvalid(CaptureLine, &HeapInfo, 1);
    DisplayAndClearHeapInfo(&HeapInfo);
    
    return 0;
}
*/

// ***********************************************************************
// ***********************************************************************
