#include "mbed.h"
#include "OLED160G1.h"

#define PI          3.1415926535897932384626433832795

OLED160G1 oled(p9, p10, p8);

int main() {
    oled.init();
    oled.eraseScreen();
    oled.setTextBackgroundType(OLED_SET_TEXT_OPAQUE);

    oled.printf("\n4D Systems 160 x 128 OLED\nmbed driver");

    wait(2);
    
    oled.drawLine(0, 0, 159, 127, oled.toRGB(0, 0, 255));
    wait_ms(100);
    oled.drawLine(159, 0, 0, 127, oled.toRGB(0, 0, 255));

    wait(2);

    for (int i = 0; i < 50; i += 1) {
        oled.drawCircle(80, 60, 3 * i, oled.toRGB(255, 0, 0));
        wait_ms(50);
    }

    for (int i = 0; i < 50; i += 1) {
        oled.drawCircle(80, 60, 3 * i, oled.toRGB(0, 0, 0));
        wait_ms(50);
    }
    
    wait(2);
    
    oled.eraseScreen();
    oled.displayControl(OLED_COMMAND_DISPLAY, 0);
    oled.displayControl(OLED_COMMAND_POWER, 0);

    while (1) {

    }
}

