/*
 * controlt.cpp
 *
 *  Created on: 2016. 2. 19.
 *      Author: sbh9428
 */

#include "controlt.h"

control_t::control_t() {
	// TODO Auto-generated constructor stub

}

control_t::control_t(temp_sensor_t* _temp_sensor, peltier_t* _peltier,BufferedSerial *_pc)
{
	log_count=0;
	time=0;
	
	target_temp=15;
	P_value=0;
	I_value=0;
	D_value=0;
	
	temp_sensor=_temp_sensor;	
	peltier=_peltier;
	pc=_pc;
	
	table_count=0;
	table_mode=0;
	
	repeatTime=0;
	repeatCount=0;
	repeatSide=0;
}

control_t::~control_t() {
	// TODO Auto-generated destructor stub
}

float control_t::get_temp()
{
	return temp_sensor->get_temp();	
}

void control_t::control_PWM(float PWM)
{
	peltier->set_PWM(PWM);
}

void control_t::control_temp()
{
	PWM_value+=calc_P();
	
	PWM_value+=calc_I();
	
	PWM_value+=calc_D();
	
	if(PWM_value>1)
	{
		PWM_value=1;	
	}
	if(PWM_value<-1)
	{
		PWM_value=-1;	
	}
	peltier->set_PWM(PWM_value);
}

void control_t::set_mode(int _mode)
{
	mode=_mode;	
	if(mode==4)
	{
		start_temp=temp_sensor->get_temp();
		time=0;
	}
}

void control_t::set_PWM_value(float _PWM_value)
{
	PWM_value=_PWM_value;
}

void control_t::set_target_temp(float _target_temp)
{
	target_temp=_target_temp;	
}

void control_t::set_P_value(float _P_value)
{
	P_value=_P_value;	
}

void control_t::set_I_value(float _I_value)
{
	I_value=_I_value;	
}

void control_t::set_D_value(float _D_value)
{
	D_value=_D_value;	
}

void control_t::set_period(int _period)
{
	period=_period;	
}

void control_t::set_start_temp(float _start_temp)
{
	start_temp=_start_temp;	
}

void control_t::refresh_PWM()
{
	write_log();
	time+=10;
	printf("\n%1.4f, %d, %d, %d, %d, %d, %d, %d, %2.2f, %2.2f, %2.2f, %2.2f", P_value, time, mode, repeatTime, repeatCount, repeatSide, highTempTime, lowTempTime, highTemp, lowTemp, target_temp, temp_sensor->get_temp());
	if(mode==0)
	{
		PWM_value=0;
		control_PWM(0);
	}
	else if(mode==1)
	{
	}
	else if(mode==2)
	{
		control_temp();
	}
	else if(mode==3)
	{
		build_table();
	}
	else if(mode==4)
	{
		follow_table();
	}
	else if(mode==5)
	{
		repeatPeriod();	
	}
}

int control_t::get_mode()
{
	return mode;
}
float control_t::get_target_temp()
{
	return target_temp;	
}
float control_t::get_P_value()
{
	return P_value;	
}
float control_t::get_I_value()
{
	return I_value;	
}
float control_t::get_D_value()
{
	return D_value;	
}
float control_t::get_PWM_value()
{
	return PWM_value;	
}

int control_t::get_period()
{
	return period;	
}

int control_t::get_table_count()
{
	return table_count;	
}

float control_t::calc_P()
{
	return (target_temp-temp_sensor->get_temp())*P_value;
}

float control_t::calc_I()
{
	float data=0;
	for(int i=0;i<10;i++)
	{
		data+=PWM_log[i];	
	}
	return data*I_value;
}

float control_t::calc_D()
{
	return -(temp_log[log_count]-temp_log[(log_count-1)%10])*D_value;
}

int control_t::get_table_check()
{
	return table_check;
}

void control_t::write_log()
{
	log_count++;
	log_count=log_count%10;
	temp_log[log_count]=temp_sensor->get_temp();
	PWM_log[log_count]=target_temp-temp_sensor->get_temp();
}

void control_t::build_table()
{
	table_check=1;
	if(table_mode==0)
	{
		peltier->set_PWM(-1);
		table_count++;
		pc->printf(",set initial temp %d/30", table_count);
		if(table_count>29)
		{
			table_mode=1;	
			table_count=0;
			time=0;
		}

	}
	else
	{	
		table[table_count]=temp_sensor->get_temp();
		table_count++;
		PWM_value=(float)-1+0.005*table_count;
		peltier->set_PWM(PWM_value);
		pc->printf(",build table %d/200", table_count);
		if(table_count>=200)
		{
			table_count=0;
			mode=0;
			table_min=table[0];
			table_max=table[200];
		}
	}
}

void control_t::print_table()
{
	int i;
	for(i=0;i<201;i++)
	{
		pc->printf(",%d/200 PWM: %1.3f, temp:%2.2f",i, (-1+0.005*i), table[i]); 	
		wait_us(3000);
	}
}

float control_t::find_table(float _temp)
{
	int i;
	
	for (i=0; i<200;i++)
	{
		if (table[i+1]>_temp)
		return -1+0.005*i;	
	}
	return 0;
}

void control_t::follow_table()
{
	if(table_check!=1)
	{
		mode=0;
		pc->printf(",table not built\n");	
	}	
	else if(target_temp>table_max|target_temp<table_min)
	{
		mode=0;
		pc->printf(",target temp out of range");	
	}
	else if(period<=step)
	{
		pc->printf(",table follow end");
		step=0;
		mode=2;
	}
	else
	{
		PWM_value=find_table(target_temp/period*step+start_temp/period*(period-step));
		peltier->set_PWM(PWM_value);
		printf(",remain step: %d",period-step);
		step++;
	}
}	

void control_t::repeatPeriod()
{
	repeatTime+=10;
	if(repeatSide==0)
	{
		target_temp=lowTemp;
		if(repeatTime>lowTempTime)
		{
			repeatSide=1;
			repeatTime=0;
		}
	}
	else
	{
		target_temp=highTemp;
		if(repeatTime>highTempTime)
		{	
			repeatSide=0;
			repeatTime=0;
			repeatCount++;
			if(repeatCount>=periodNumber)
			{
				repeatSide=0;
				repeatTime=0;
				repeatCount=0;
				mode=0;	
			}
		}
			
	}
	control_temp();
	
}