#include "mbed.h"

#include "BufferedSerial.h"
#include "FastAnalogIn.h"
#include "FastPWM.h"

#include "commandt.h"
#include "controlt.h"
#include "peltiert.h"
#include "tempsensort.h"

Ticker controltick;

AnalogIn temp_sensor_pin(p20);

temp_sensor_t temp_sensor(&temp_sensor_pin);



FastPWM PWM_pin(p23);
DigitalOut PWM_dir(p22);



peltier_t peltier(&PWM_pin, &PWM_dir);








BufferedSerial pc(USBTX, USBRX, 2048);

control_t control(&temp_sensor, &peltier, &pc);

command_t command(&pc, &control);



void peltier_control();

int main() {
    
    pc.printf("temperature start \n");
    
    controltick.attach(&peltier_control, 10);// sampling time
    
    wait(10);
    
    while(1) 
    {
        while(pc.readable())
        {
            command.get_data();   
        }
    }
    
}

void peltier_control()
{
      command.refreshPWM();
}