/*
 * controlt.h
 *
 *  Created on: 2016. 2. 19.
 *      Author: sbh9428
 */

#ifndef CONTROLT_H_
#define CONTROLT_H_

#include "BufferedSerial.h"
#include "tempsensort.h"
#include "peltiert.h"

class control_t {
public:
	float get_temp();
	void control_PWM(float _PWM);
	void control_temp();
	
	void set_mode(int _mode);
	void set_target_temp(float _target_temp);
	void set_PWM_value(float _PWM_value);
	void set_P_value(float _P_value);
	void set_I_value(float _I_value);
	void set_D_value(float _D_value);
	void set_period(int _period);
	void set_start_temp(float _start_temp);
	
	void refresh_PWM();
	
	int get_mode();
	float get_target_temp();
	float get_P_value();
	float get_I_value();
	float get_D_value();
	float get_PWM_value();
	int get_period();
	int get_table_check();
	int get_table_count();
	
	float calc_P();
	float calc_I();
	float calc_D();
	
	void write_log();
	
	void print_table();
	void follow_table();
	
	float highTemp;
	float lowTemp;
	
	int highTempTime;
	int lowTempTime;
	int periodNumber;
	
	void repeatPeriod();
	
	int repeatTime;
	int repeatCount;
	int repeatSide;
	
	control_t();
	control_t(temp_sensor_t* _temp_sensor, peltier_t* _peltier,BufferedSerial* _pc);
	virtual ~control_t();
private:
	float P_value;
	float I_value;
	float D_value;
	
	float PWM_value;
	
	float target_temp;
	
	float dif;
	
	float temp_log[10];
	float PWM_log[10];
	int log_count;
	
	int time;
	
	float table[201];
	int table_count;
	int table_mode;
	int table_check;
	float table_min;
	float table_max;
	float start_temp;
	
	int period;
	int step;
	
	void build_table();
	float find_table(float _temp);
	
	temp_sensor_t* temp_sensor;
	peltier_t* peltier;
	BufferedSerial *pc;
	
	int mode;//0: stop 1: set pwm 2: set temp
};

#endif /* CONTROLT_H_ */

