/*
 * commandt.cpp
 *
 *  Created on: 2016. 2. 19.
 *      Author: sbh9428
 */

#include "commandt.h"

command_t::command_t() {
	// TODO Auto-generated constructor stub

}

command_t::command_t(BufferedSerial* _pc, control_t* _control)
{
	time=0;
	count=0;
	control=_control;
	pc=_pc;	
	pc->baud(115200);
}

command_t::~command_t() {
	// TODO Auto-generated destructor stub
}

void command_t::clear_data()
{
	for(int i=0;i<10;i++)
	{
		data[i]=0;	
	}	
}
void command_t::parse()
{
	switch(data[0])
	{
		case 's':
			switch(data[1])
			{
				case 'm':
					control->set_mode(data[2]-'0');
					printf("set mode %d\n", data[2]-'0');
				break;
				case 'r':
					control->control_PWM(asci_to_bin(data+2));
					control->set_PWM_value(asci_to_bin(data+2));
					printf("set PWM duty ratio %f1.5\n", asci_to_bin(data+2));
				break;
				case 't':
					control->set_target_temp(asci_to_bin(data+2));
					printf("set target temp %f\n", asci_to_bin(data+2));
				break;	
				case 'p':
					control->set_P_value(asci_to_bin(data+2));
					printf("set P value %f\n", asci_to_bin(data+2));
				break;	
				case 'i':
					control->set_I_value(asci_to_bin(data+2));
					printf("set I value %f\n", asci_to_bin(data+2));
				break;	
				case 'd':
					control->set_D_value(asci_to_bin(data+2));
					printf("set D value %f\n", asci_to_bin(data+2));
				break;	
				case 'e':
					control->set_period((int)asci_to_bin(data+2));
					printf("set period %d\n", (int)asci_to_bin(data+2));
				break;
				case 'h':
					control->highTemp=asci_to_bin(data+2);
					printf("set high temp %2.2f\n", asci_to_bin(data+2));
				break;
				case 'l':
					control->lowTemp=asci_to_bin(data+2);
					printf("set low temp %2.2f\n", asci_to_bin(data+2));
				break;
				case 'a':
					control->highTempTime=(int)asci_to_bin(data+2);
					printf("set high temp time%d\n", (int)asci_to_bin(data+2));
				break;
				case 'b':
					control->lowTempTime=(int)asci_to_bin(data+2);
					printf("set low temp %d\n", (int)asci_to_bin(data+2));
				break;
				case 'o':
					control->periodNumber=(int)asci_to_bin(data+2);
					printf("set period repeat number %d \n", (int)asci_to_bin(data+2));
					break;
				default:
				pc->printf("command error");
			}
		break;
		case 'g':
			switch(data[1])
			{
				case 'm':
					printf("mode is %d\n", control->get_mode());
				break;
				case 'r':
					printf("duty ratio is %f\n", control->get_PWM_value());
				break;
				case 't':
					printf("target temp is %f\n", control->get_target_temp());
				break;
				case 'p':	
					printf("P value is %f\n", control->get_P_value());
				break;
				case 'i':
					printf("I value is %f\n", control->get_I_value());
				break;
				case 'd':
					printf("D value is %f\n", control->get_P_value());
				break;
				case 'e':
					printf("Period is %d\n", control->get_period());
					break;
				case 'a':
					control->print_table();
					break;
				default:
				pc->printf("command error");
			}
		
		break;	
		dafault:
		pc->printf("command error");
	}
	pc->printf("\n");
	count=0;
}

void command_t::get_data()
{
    data [count]=pc->getc();

    if(data [count]=='f')
	parse();
	else
    count++;

    if(count>9)
    {
        count=0;
         pc->printf("command error\n");
     }
}

void command_t::refreshPWM()
{
	time=time+3;
	control->refresh_PWM();
}

double command_t::asci_to_bin(int *start)
{
	double _data=0;
	int current=0;

	double nth=1; //�ڸ���
	int mode=0;
	int sign=1;
	
	if(*start=='-')
	{
		current++;	
		sign=-1;
	}
	while(*(start+current)!='f'&&*(start+current)!='.')
	{
		_data*=10;
		_data+=*(start+current)-'0';

		current++;
	}
	if(*(start+current)=='.')
	{
		current++;
		while(*(start+current)!='f')
		{
			nth/=10;
			_data+=nth*(*(start+current)-'0');
			current++;
		}	
	}
	return sign*_data;
}