#include "mbed.h"
#include "humsensort.h"
#include "FastPWM.h"
#include "controlt.h"
#include "commandt.h"
#include "pumpt.h"

BufferedSerial pc(USBTX, USBRX, 2048);

AnalogIn humidityPin(p20);

humSensor_t humSensor(&humidityPin);

FastPWM wetPin(p21);
FastPWM dryPin(p22);

pump_t wetPump(&wetPin);
pump_t dryPump(&dryPin);

Ticker sysTick;

control_t control(&dryPump, &wetPump, &humSensor, &pc);

command_t command(&pc, &control);

void refreshPWM();

int main()
{
    sysTick.attach(&refreshPWM, 5); 
    while(1)
    {
 
        while(pc.readable())
        {
            command.get_data();

        }
    }
}

void refreshPWM()
{
    control.refreshPWM();   
}