/*
 * controlt.h
 *
 *  Created on: 2016. 2. 19.
 *      Author: sbh9428
 */

#ifndef CONTROLT_H_
#define CONTROLT_H_

#include "BufferedSerial.h"
#include "humsensort.h"
#include "pumpt.h"

class control_t {
public:
	void setP(float _P);
	void setI(float _I);
	void setD(float _D);

	void setMode(int _mode);

	void setPower(float _power);
	void setRatio(float _ratio);

	float getP();
	float getI();
	float getD();

	int getMode();

	float getPower();
	float getRatio();

	void refreshPWM();

	float calculatePID();

	control_t();
	control_t(pump_t *_dry, pump_t *_wet, humSensor_t *_humSensor, BufferedSerial *_pc);
	virtual ~control_t();
private:
	float P;
	float I;
	float D;

	int mode;

	float power;
	float ratio;

	float humidity;
	
	float dryValue;
	float wetValue;

	humSensor_t *humSensor;

	pump_t *dry;
	pump_t *wet;
	
	Ticker refresh;
	
	BufferedSerial *pc;
};

#endif /* CONTROLT_H_ */



