/*
 * commandt.cpp
 *
 *  Created on: 2016. 2. 19.
 *      Author: sbh9428
 */

#include "commandt.h"

command_t::command_t() {
	// TODO Auto-generated constructor stub

}

command_t::command_t(BufferedSerial* _pc, control_t* _control)
{
	time=0;
	count=0;
	control=_control;
	pc=_pc;	
}

command_t::~command_t() {
	// TODO Auto-generated destructor stub
}

void command_t::clear_data()
{
	for(int i=0;i<10;i++)
	{
		data[i]=0;	
	}	
}
void command_t::parse()
{
	switch(data[0])
	{
		case 's':
			switch(data[1])
			{
				case 'm':
					control->setMode(data[2]-'0');
					printf("set mode %d\n", data[2]-'0');
				break;
				case 'p':
					control->setP(asci_to_bin(data+2));
					printf("set P %f1.5\n", asci_to_bin(data+2));
				break;
				case 'i':
					control->setI(asci_to_bin(data+2));
					printf("set I %f\n", asci_to_bin(data+2));
				break;	
				case 'd':
					control->setD(asci_to_bin(data+2));
					printf("set D %f\n", asci_to_bin(data+2));
				break;	
				case 'o':
					control->setPower(asci_to_bin(data+2));
					printf("set I value %f\n", asci_to_bin(data+2));
				break;	
				case 'a':
					control->setRatio(asci_to_bin(data+2));
					printf("set Ratio %f\n", asci_to_bin(data+2));
				break;	
			}
		break;
		case 'g':
			switch(data[1])
			{
				case 'm':
					printf("mode is %d\n", control->getMode());
				break;
				case 'p':
					printf("P is %f\n", control->getP());
				break;
				case 'i':
					printf("I is %f\n", control->getI());
				break;
				case 'd':	
					printf("D is %f\n", control->getD());
				break;
				case 'o':
					printf("power is %f\n", control->getPower());
				break;
				case 'a':
					printf("ratio is %f\n", control->getRatio());
				break;
			}
		
		break;	
		dafault:
		pc->printf("command error");
	}
	pc->printf("\n");
	count=0;
}

void command_t::get_data()
{
    data [count]=pc->getc();

    if(data [count]=='f')
	parse();
	else
    count++;

    if(count>9)
    {
        count=0;
         pc->printf("command error\n");
     }
}

double command_t::asci_to_bin(int *start)
{
	double _data=0;
	int current=0;

	double nth=1; //�ڸ���
	int mode=0;
	int sign=1;
	
	if(*start=='-')
	{
		current++;	
		sign=-1;
	}
	while(*(start+current)!='f'&&*(start+current)!='.')
	{
		_data*=10;
		_data+=*(start+current)-'0';

		current++;
	}
	if(*(start+current)=='.')
	{
		current++;
		while(*(start+current)!='f')
		{
			nth/=10;
			_data+=nth*(*(start+current)-'0');
			current++;
		}	
	}
	return sign*_data;
}
