#include "MQTTESP8266.h"
#include "MQTTClient.h"
#include "string.h"
#include "rgbled.h"
#include "MbedJSONValue.h"
char buf[100];

MQTTESP8266 ipstack(D1, D0, D10, "Sidsap10","Arduino111"); // change to match your wifi access point
float version = 0.47;
char* topic = "k64";
char* topic2 = "k64rec";
char* topic3 = "bulb";    
char* key2 = "key";
char* hostname = "192.168.43.87"; // Ip 
int port = 1883;
int rc = ipstack.connect(hostname, port);
unsigned int previousTime = 0;        // will store last time LED was updated

// constants won't change:
const long interval = 20;
int flag =0;
MQTT::Client<MQTTESP8266, Countdown> client = MQTT::Client<MQTTESP8266, Countdown>(ipstack);
//MbedJSONValue demo;
int arrivedcount = 0;
//using namespace std;
std::string my_str;
std::string my_str2;
std::string someString;
std::string clearsky ("clear");
std::string clouds ("few clouds");
std::string snow ("light snow");
std::string automatic ("automatic");
std::string manual ("manual");
int j=0;
rgbled rgb(PTB22, PTE26, PTB21);                // create rgb object with pin definitions for FRDM-K64F board

// callback for subscribe topic

void subscribeCallback(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message received: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    
    printf("%s",(char*)message.payload);
    printf("\r\n");
    
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    printf("nonedited payload is %s and payload is %d\r\n",(char*)message.payload,message.payloadlen);
    
    // int f = int(message.payload);
     
     std::string someString((char*)message.payload);
     someString.resize (message.payloadlen);  
     printf("Edited payload iss %s \r\n",someString.c_str());
     //j= someString.find(clouds);
     //printf("j = %d \r\n", j);
  
    if ( !(someString.find(clouds)) )
    {  
       sprintf(buf, "dCglDR-G9WoQUiig0XMNhOV4ozIEIVu3rWdBh5IlQ7d,cloud %s\n", key2);
       message.payload = (void*)buf;
       message.payloadlen = strlen(buf)+1;
       rc = client.publish(topic3, message);
       printf("if condition checked, its cloudy\r\n");
       //rgb.set(red);
       
    }
    else  if ( !(someString.find(clearsky)) )
    {  
       sprintf(buf, "dCglDR-G9WoQUiig0XMNhOV4ozIEIVu3rWdBh5IlQ7d,clearsky %s\r\n", key2);
       message.payload = (void*)buf;
       message.payloadlen = strlen(buf)+1;
       rc = client.publish(topic3, message);
       printf("if condition checked, its clear\r\n");
       
       //rgb.set(yellow);
    }
    else  if ( !(someString.find(snow)) )
    {  
      
       sprintf(buf, "dCglDR-G9WoQUiig0XMNhOV4ozIEIVu3rWdBh5IlQ7d,snow %s\r\n",key2);
       message.payload = (void*)buf;
       message.payloadlen = strlen(buf)+1;
       rc = client.publish(topic3, message);
       printf("if condition checked, its snowy\r\n");
      
      // rgb.set(blue);
    }
    else  if ( !(someString.find(automatic)) )
    {  
       
       printf("Automatic, i.e  Decide based on weather \r\n");
       flag = 0;
      // rgb.set(blue);
    }
    else  if ( !(someString.find(manual)) )
    {  
       
       printf("Manual Flag set \r\n");
       flag = 1;
      // rgb.set(blue);
    }
    else
    {
        printf("went into else\r\n");
    }

}

int main(int argc, char* argv[])
{  
    wait (1);
    printf("Starting\r\n");
    
    set_time(1256729737); 
    time_t seconds = time(NULL);
    previousTime = (unsigned int)seconds;
    
    
    printf("Version is %f\r\n", version);
   
   rgb.active(false);                              // set led output to active low
   rgb.set(none);                                  // set led output of all off
  
    

    if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    //data.MQTTVersion = 3;
    //data.clientID.cstring = "mbed-clientID";
    //data.username.cstring = "testuser";
    //data.password.cstring = "testpassword";
    
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    if ((rc = client.subscribe(topic2, MQTT::QOS1, subscribeCallback)) != 0)
        printf("Recv'd from MQTT subscribe is %d\r\n", rc);

    MQTT::Message message;
    // QoS 0
    
     
    sprintf(buf, "fa02d31610ce9ea0de15b22bb2fe279d, %s\r\n", key2);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    
    
    rc = client.publish(topic, message);
    wait(5);
   
    /*
    sprintf(buf, "dCglDR-G9WoQUiig0XMNhOV4ozIEIVu3rWdBh5IlQ7d, %s\r\n", key2);
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic2, message);
    */
    
    while (arrivedcount < 10)
       { client.yield(100);
        
        time_t seconds = time(NULL);
        //printf("%u\r\n", (unsigned int)seconds);
        wait(1);
        if ( seconds - previousTime >= interval  )
           {
               if (flag ==0)
               {
        //printf("its been a few seconds \r\n");    
        printf("Checking the weather\r\n");
        previousTime =seconds; 
        sprintf(buf, "fa02d31610ce9ea0de15b22bb2fe279d, %s\r\n", key2);
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf)+1;
        rc = client.publish(topic, message);
              }
            } 
        }
    
     
  /*
    // QoS 1
    sprintf(buf, "Hello World!  QoS 1 message from app version %f\r\n", version);
    message.qos = MQTT::QOS1;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 10)
        client.yield(100);
    
    // QoS 2
    sprintf(buf, "Hello World!  QoS 2 message from app version %f\r\n", version);
    message.qos = MQTT::QOS2;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 3)
        client.yield(100);

    // n * QoS 2
    
    for (int i = 1; i <= 10; ++i) {
        sprintf(buf, "Hello World!  QoS 2 message number %d from app version %f\r\n", i, version);
        message.qos = MQTT::QOS2;
        message.payloadlen = strlen(buf)+1;
        rc = client.publish(topic, message);
        while (arrivedcount < i + 3)
            client.yield(100);
    }
    */
    
    if ((rc = client.unsubscribe(topic)) != 0)
        printf("rc from unsubscribe was %d\r\n", rc);

    if ((rc = client.disconnect()) != 0)
        printf("rc from disconnect was %d\r\n", rc);

    //ipstack.disconnect();
    //printf("Finishing with %d messages received\r\n", arrivedcount);

    return 0;
}
