
#include "mbed.h"
#include "titranje.h"
AnalogIn pot(A0); // crveni kabel
InterruptIn tipkalo(D2,PullUp); //tipkalo
DigitalOut crvena(D13); 
DigitalOut zuta(D12);
DigitalOut zelena(D11);
DigitalOut e(D4); //tamnoplavi kabel
DigitalOut f(D5); //ljubičasti kabel
DigitalOut b(D6); //sivi kabel
DigitalOut c(D7); //bijeli kabel
PwmOut buzzer(D10); //narancasti kabel

Ticker mamacL;
Ticker mamacD;
Timer debounce;

float datap;
int on=1, off=0;

float frequency[]={659,554,659,554,550,494,554,587,494,659,554,440}; //frequency array oranges and lemo
float beat[]={1,1,1,1,1,0.5,0.5,1,1,1,1,2};

void zvuk(void);
void titrajL(void);
void titrajD(void);
void blink(void);
void blinkL(void);        
void blinkD(void);   
titranje led(LED2);

int main() {
    debounce.start();
    buzzer=off;
    tipkalo.rise(&zvuk);
  led.stanje_ok();
    
    while (1){
       datap=pot.read();
       
       if (datap<=0.5) {
            mamacL.attach(&blinkL,0.4);
            f=e=1;
            b=c=0;
            titrajL();}
        else{
            mamacD.attach(&blinkD,0.4);
            f=e=0;
            b=c=1;
            titrajD();}
       
}}
 
void zvuk(void) {
    crvena=zuta=zelena=1;
    b=c=f=e=1;
    
    if(debounce.read_ms()>200){
        
for (int i=0; i<=12; i++) {
            blink();
            
            buzzer.period(1/(frequency[i])); // set PWM period
            buzzer=0.5; // set duty cycle
            wait(0.5*beat[i]);
                 if(i==12){
                    buzzer=off;

                    debounce.reset();
     break;}
     }
} }

void blinkL(void) {
    f=!f;
    e=!e;
    mamacL.detach();}
    
void blinkD(void) {
    b=!b;
    c=!c;
    mamacD.detach();}
    
void titrajL(void) {
    crvena=1;
    zuta=0;
    zelena=0;
    wait(0.4);
    crvena=1;
    zuta=1;
    zelena=0;
    wait(0.4);
    crvena=1;
    zuta=1;
    zelena=1;
    wait(0.4);
    crvena=1;
    zuta=1;
    zelena=0;
    wait(0.4);
    crvena=1;
    zuta=0;
    zelena=0;
    wait(0.4);
    crvena=0;
    zuta=0;
    zelena=0;
    wait(0.4);}

void titrajD(void) {
    crvena=0;
    zuta=0;
    zelena=1;
    wait(0.4);
    crvena=0;
    zuta=1;
    zelena=1;
    wait(0.4);
    crvena=1;
    zuta=1;
    zelena=1;
    wait(0.4);
    crvena=0;
    zuta=1;
    zelena=1;
    wait(0.4);
    crvena=0;
    zuta=0;
    zelena=1;
    wait(0.4);
    crvena=0;
    zuta=0;
    zelena=0;
    wait(0.4);}
    
void blink(void){
    crvena=!crvena;
    zuta=!zuta;
    zelena=!zelena;
    b=!b;
    c=!c;
    f=!f;
    e=!e;
    }
    