#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define LCDTIME 0.25
#define PROGNAME "kl46z_slider_mid_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
Timer LCDTimer;
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
    LCDTimer.start();
    LCDTimer.reset();
    displayState = 3;
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

float newtonSqrRt(float a) {
    
    float xnew = 0.0;
    int intmax = 20;
    //int n_int = 0;
    float epsilon = 1e-7;
    float xold = (a/2.5);    //Make a guess
    
    for (int i = 0; i < intmax; i++)
    {
        xnew = 0.5 * (xold + (a/xold));    //Calculation
        float delta = fabs(xnew - xold);    //Compare old and new values
        
        if (delta < epsilon)
            break;
        else
            xold = xnew;
    }
    
    return xnew;
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                    // do something here.
                    switch (displayState) {
                        case 0: //R BUTTON
                            rled = 1.0;
                            gled = 0.0;
                            
                            break;
                        case 1: //L BUTTON
                            rled = 0.0;
                            gled = 1.0;

                            break;
                        }
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
            //rled = 1.0;
            //gled = 0.0;       
        }
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();        
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                }           
            }
            lastTouch=tsidata;
        }
        
        if (LCDTimer.read() > LCDTIME) {
            LCDTimer.reset();
            switch(displayState) {
                case 0: //R BUtton                                                
                    float sqrRoot = newtonSqrRt(lastTouch);
                    sprintf (lcdData,"%0.2f", sqrRoot * 10);
                    LCDMess(lcdData);
                    break;
                case 1: //L Button
                    sprintf (lcdData,"%0.2f", (tsidata * 100));  
                    LCDMess(lcdData);
                    break;
                default:
                    break;
                }    
        }
    }
}