#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

#define PROGNAME "sbart_lightsense_kl46z pt2\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22

SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;
InterruptIn btnRight(PTC3);
InterruptIn btnLeft(PTC12);
//AnalogIn lightInRaw();
bool bLCDSwitch = true; //When true, display floating point number
short rawData;
float tsiData;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void btnRightPressed(){
    bLCDSwitch = true;
    pc.printf("btnRightPressed()");

}

void btnLeftPressed(){
    bLCDSwitch = false;
    pc.printf("btnLeftPressed()");
}

int main() {
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData; 
    char lcdData[LCDLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    TSISensor tsi;
       
    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    btnRight.fall(&btnRightPressed);
    btnLeft.fall(&btnLeftPressed);
    
    while(true) {    
        if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
            lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity
            if(bLCDSwitch == true) {
                sprintf(lcdData,"%4.3f",lightData);
                pc.printf(lcdData);
                pc.printf("\r\n");
            }
            else {
                rawData = LightSensor.read_u16();
                tsiData = tsi.readPercentage();
                if(tsiData > .5)
                    rawData = rawData/10;
                sprintf(lcdData, "%u", rawData);
                pc.printf(lcdData);
                pc.printf("\r\n");
            }
            LCDMess(lcdData);
            gled = lightData;
            rled = lightData;
            timeToChangeDF = DATATIME;
            LEDTimer.reset();
        }        
    }// emd while
}
