#include "mbed.h"
#include "MMA8451Q8g.h"
#include "SLCD.h"

#define BLINKTIME   1.5
#define RELAYON     0
#define RELAYOFF    1
#define LEDDELAY    0.4
#define WAITDELAY   0.7
#define LCDLEN      10
#define PROG_NAME "sbart_doubletap_kl46z pt2\n"

#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05
#define REG_PULSE_CFG     0x21
#define REG_PULSE_SRC     0x22
#define REG_PULSE_THSZ    0x25
#define REH_PULSE_TMLT    0x26

#define PULSE_LTCY_REG    0x27  //SB - The pulse latency register
#define REG_CTRL_1        0x2A  //SB - For setting the data rate

#define REG_CTRL_4        0x2D
#define REG_CTRL_5        0x2E

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02
#define SET_INTERRUPT     0x08 //SB - enable pulse interrupt
#define SET_INT_LINE      0x00  //SB - set to INT2
#define SET_THZ           0x28 //SB - 2.5g/0.063g/count = 40 counts

#define SET_LTCY          0x1C //SB - Set pulse latency to 35 ms (28 * 1.25ms)

#define REG_1_OR_MASK     0x08 //SB - Mask to set in REG_CTRL_1
#define REG_1_AND_MASK    0xC7
/***********
0b0010 0000
2g/0.063g/count = 32 counts
************/
#define SET_TMLT          0x18 // See Talbe 51 in data sheet
/******
0b0001 1000
24 = 0x18
time step at 800Hz ODR = 0.625ms
24x0.625 = 15 ms
******/

//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
Ticker ledBlink; // timinginterrupt for RED led

//SB - change interrupt pin address
InterruptIn MMA8451QInt1(PTD1);  //push botton with internal pullup

DigitalOut myled(LED_RED); // red led
DigitalOut relay(LED_GREEN); // green led

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

float delay = WAITDELAY;
int relayState = RELAYOFF;
int outState = false;
SLCD slcd; //define LCD display
char LCDMessages[2][LCDLEN] = {"TRUE", "FALS"};

Serial pc(USBTX, USBRX);

void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

// Interrupt routines
void LEDBlinker(){  // RED LED interrupt
    outState = !outState; 
    myled.write(outState);
}

void GreenLEDBlinker(){  // Green LED interrupt
    //uint8_t i_regData; 
    relayState = !relayState; 
    relay.write(relayState);
    //acc.readRegs(REG_PULSE_SRC, &i_regData, 1); // Clear the tap event
}        

// end interrupt routines

int main()
{
    pc.printf(PROG_NAME);
        
    uint8_t regData; 
    uint8_t latchData = 0x40; //0b01000000; //for pulse config register
    uint8_t axisData = 0x20; // 0b00100000;  //SB - set for double tap

    char lcdData[LCDLEN];
    
    myled.write(outState);
    relay.write(relayState);
    
// set up interrrupts to be used later for taps
    MMA8451QInt1.rise(&GreenLEDBlinker);
    MMA8451QInt1.mode(PullNone); 
   
// set up interrrupts to be used later for taps
    ledBlink.attach(&LEDBlinker, LEDDELAY);
  
// Read Pulse Source Data and check to see if things have been set
    acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME); 
    
// *********** Initialize for tap tecognition ***********      
    regData = latchData | axisData;
    acc.setRegisterInStandby(REG_PULSE_CFG, regData); // write the data
    acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME);     
    
// Check to see if accerlometer is alive and well
    acc.setGLimit(MAX_4G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"%x",regData); // Note displaying in hexidecimal
    LCDMess(lcdData,BLINKTIME);
    
    //print REG_CTRL_1 to serial
    pc.printf("REG_CTRL_1: ");
    pc.printf("%2X", REG_CTRL_1);
    pc.printf("\n");
    pc.printf("REG_1_AND_MASK: ");
    pc.printf("%2X", REG_1_AND_MASK);
    pc.printf("\n");
    pc.printf("REG_1_AND_MASK: ");
    pc.printf("%2X", REG_1_OR_MASK);
    pc.printf("\n");
    
    //SB - Set up the ODR to 400Hz using masks to clear and preserve the bits
    acc.readRegs(REG_CTRL_1, &regData, 1);
    
    regData = regData & REG_1_AND_MASK; //SB - clear needed bits while preserving others
    regData = regData | REG_1_OR_MASK;  //SB - Activate required bit, while preserving others
    
    acc.setRegisterInStandby(REG_CTRL_1, regData);
    
    pc.printf("REG_CTRL_1 data: ");
    pc.printf("%2X", regData);
    pc.printf("\n");
    
    //print REG_CTRL_1 to serial
    
// Setup single-tap pulse prarameters.
   acc.setRegisterInStandby(REG_PULSE_THSZ, SET_THZ); // write the data
   acc.setRegisterInStandby(REH_PULSE_TMLT, SET_TMLT); // write the data 
      
// Set up (pulse) interrupt to INT1 pin
    acc.setRegisterInStandby(REG_CTRL_4, SET_INTERRUPT); // write the data
    acc.setRegisterInStandby(REG_CTRL_5, SET_INT_LINE); // write the data

//SB - Set up pulse latency (transient time?)
   acc.setRegisterInStandby(PULSE_LTCY_REG, SET_LTCY); 
// End or seetup    

//Printing  other registers

    //register 4
    pc.printf("REG_CTRL_4: ");
    pc.printf("%X", REG_CTRL_4);
    pc.printf("\n");
    //register 4 data
    pc.printf("REG_CTRL_4 data: ");
    pc.printf("%X", SET_INTERRUPT);
    pc.printf("\n");
    
    //register 5
    pc.printf("REG_CTRL_5: ");
    pc.printf("%X", REG_CTRL_5);
    pc.printf("\n");
    //register 5 data
    pc.printf("REG_CTRL_5 data: ");
    pc.printf("%X", SET_INT_LINE);
    pc.printf("\n");
    
    //pulse source register
    pc.printf("REG_PULSE_SRC: ");
    pc.printf("%X", REG_PULSE_SRC);
    pc.printf("\n");
    
    //pulse threshold
    pc.printf("REG_PULSE_THSZ: ");
    pc.printf("%X", REG_PULSE_THSZ);
    pc.printf("\n");
    //pulse threshold data
    pc.printf("REG_PULSE_THSZ data: ");
    pc.printf("%X", SET_THZ);
    pc.printf("\n");
    
    //pulse time limit
    pc.printf("REH_PULSE_TMLT: ");
    pc.printf("%X", REH_PULSE_TMLT);
    pc.printf("\n");
    //pulse time limit data
    pc.printf("REH_PULSE_TMLT data: ");
    pc.printf("%X", SET_TMLT);
    pc.printf("\n");
    
    //pulse latency
    pc.printf("PULSE_LTCY_REG: ");
    pc.printf("%X", PULSE_LTCY_REG);
    pc.printf("\n");
    //pulse latency data
    pc.printf("PULSE_LTCY_REG data: ");
    pc.printf("%X", SET_LTCY);
    pc.printf("\n");
    pc.printf("\n");
    
    

    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME); 
  
    
    while (true) { 
        acc.readRegs(REG_PULSE_SRC, &regData, 1);
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME);           
        LCDMessNoDwell(LCDMessages[relayState]);  
        wait(delay);
        
        pc.printf("REG_PULSE_SRC: ");
        pc.printf("%X", REG_PULSE_SRC);
        pc.printf("\n");
        pc.printf("REG_PULSE_SRC regData: ");
        pc.printf("%X", regData);
        pc.printf("\n");
    }
}