#include "mbed.h"
#include <math.h> 
#include "MMA8451Q.h"
#include "SLCD.h"

/* 
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

#define DATAINTERVAL 0.200
#define LCDDATALEN 10

#define LCDWAIT 1.5

#define NUMBUTS 1
#define LBUT PTC12  // port addresses for buttons
//#define RBUT PTC3
#define BUTTONTIME 0.1

#define PROGNAME "ACCLCD341-541\r\n"
#define LCDTIME 1.5

#define PRINTDBUG
// 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
Timer dataTimer;

Timer ButtonTimer; // for reading button states
Timer LCDTimer;

DigitalIn buttons[NUMBUTS] = {LBUT};

char axisName[3] = {'X', 'Y', 'Z'};

int currentAxis;
int displayState;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDsignedFloat(float theNumber){
    sprintf (lcdData," %3.2f",theNumber); 
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));   
    LCDMess(lcdData);
} 

void initialize_global_vars(){
    pc.printf(PROGNAME);
    dataTimer.start();
    dataTimer.reset();
    
    ButtonTimer.start();
    ButtonTimer.reset();
    
    currentAxis = 0;
    displayState = 0;
    
//    LCDTimer.start();
//    LCDTimer.reset();
} 

int main() {
    float xAcc;
    float yAcc; 
    float zAcc; 
    
    initialize_global_vars();
// main loop forever 
    while(true) {
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();             
//Get accelerometer data - tilt angles minus offset for zero mark.
            xAcc = acc.getAccX();
            yAcc = acc.getAccY(); 
            zAcc = acc.getAccZ();     
 
#ifdef PRINTDBUG
        pc.printf("xAcc = %f\r\n", xAcc);
        pc.printf("yAcc = %f\r\n", yAcc);
        pc.printf("zAcc = %f\r\n", zAcc);
#endif

while (true) {
        if (ButtonTimer > BUTTONTIME){
            //float count = 0;
            for (int i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[0]) { 
                pc.printf("Left Button Clicked");
                //char ch_ds = displayState;
                //pc.printf("displayState = " + ch_ds);
                    displayState++;
                    if(displayState > 3)
                        displayState = 1;
                    // do something here.
                                    switch (displayState) {
                        case 1:
                            pc.printf("Case1");
//                            currentAxis = xAcc;
                            currentAxis = displayState - 1;
//                            LCDMess((char*)axisName[currentAxis]);
                            slcd.clear();
                            slcd.putc('X');
                            wait(LCDWAIT);
                            xAcc = acc.getAccX();
                            LCDsignedFloat(xAcc);
                            break;
                        case 2:
                            pc.printf("Case2");
//                            currentAxis = yAcc;
                            currentAxis = displayState - 1;
//                            LCDMess((char*)axisName[currentAxis]);
                            slcd.clear();
                            slcd.putc('Y');
                            wait(LCDWAIT);
                            yAcc = acc.getAccY();
                            LCDsignedFloat(yAcc);
                            break;
                        case 3:
                            pc.printf("Case3");
//                            currentAxis = zAcc;
                            currentAxis = displayState - 1;
//                            LCDMess((char*)axisName[currentAxis]);
                            slcd.clear();
                            slcd.putc('Z');
                            wait(LCDWAIT);
                            zAcc = acc.getAccZ();
                            LCDsignedFloat(zAcc);
                            break;
                        default:
//                            currentAxis = xAcc;
                            xAcc = acc.getAccX();
                            LCDsignedFloat(xAcc);
                            break;
                        }
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();   
        }


    }
}

// Wait then do the whole thing again.
//       }
    }
}