/* mbed USBHost Gamepad driver sample
 * Copyright (c) 2014 Yuuichi Akagawa
 *
 * modified from mbed USBHostMouse
 *
 * Copyright (c) 2014 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef USBHOSTGAMEPAD_H
#define USBHOSTGAMEPAD_H

#include "USBHostConf.h"

//#if USBHOST_GAMEPAD

#include "USBHost.h"
//HID Class Request
#define HID_GET_REPORT                                 0x01
#define HID_GET_IDLE                                   0x02
#define HID_GET_PROTOCOL                               0x03
#define HID_GET_DESCRIPTOR                             0x06
#define HID_SET_REPORT                                 0x09
#define HID_SET_IDLE                                   0x0a
#define HID_SET_PROTOCOL                               0x0b

/** 
 * A class to communicate a USB MIDI device
 */
class USBHostGamepad : public IUSBEnumerator {
public:
    /**
     * Constructor
     */
    USBHostGamepad();

    /**
     * Try to connect a gamepad device
     *
     * @return true if connection was successful
     */
    bool connect();

    /**
    * Check if a gamepad is connected
    *
    * @returns true if a gamepad is connected
    */
    bool connected();

    /**
     * Attach a callback called when a gamepad event is received
     *
     * @param ptr function pointer
     */
//    inline void attachEvent(void (*ptr)(uint8_t btnX, uint8_t btnY, uint8_t btnABCD, uint8_t btnSpecial)) {
    inline void attachEvent(void (*ptr)(uint8_t btn00, uint8_t btn01, uint8_t btn02, uint8_t btn03, uint8_t btn04, uint8_t btn05, uint8_t btn06, uint8_t btn07, uint8_t btn08, uint8_t btn09, uint8_t btn10, uint8_t btn11, uint8_t btn12, uint8_t btn13, uint8_t btn14, uint8_t btn15, uint16_t gamePadVID, uint16_t gamePadPID)) {
        if (ptr != NULL) {
            onUpdate = ptr;
        }
    }

    /**
    * Request the HID report descriptor
    *
    * @param dev request the device descriptor on this device
    * @param buf buffer to store the device descriptor
    * @param max_len_buf maximum size of buf
    * @param len_dev_descr pointer to store the length of the packet transferred
    */
    USB_TYPE getReportDescriptor(USBDeviceConnected * dev, uint8_t * buf, uint16_t max_len_buf, uint16_t * len_rep_descr = NULL);
    
protected:
    //From IUSBEnumerator
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); //Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); //Must return true if the endpoint will be used

private:
    USBHost * host;
    USBDeviceConnected * dev;
    USBEndpoint * int_in;
//    uint8_t report[8];
    uint8_t report[16];
    
    uint16_t    gamePad_VID;
    uint16_t    gamePad_PID;

    bool dev_connected;
    bool gamepad_device_found;
    int gamepad_intf;

    uint8_t btnX;
    uint8_t btnY;
    uint8_t btnABCD;
    uint8_t btnSpecial;

    uint8_t btn00;
    uint8_t btn01;
    uint8_t btn02;
    uint8_t btn03;
    uint8_t btn04;
    uint8_t btn05;
    uint8_t btn06;
    uint8_t btn07;
    uint8_t btn08;
    uint8_t btn09;
    uint8_t btn10;
    uint8_t btn11;
    uint8_t btn12;
    uint8_t btn13;
    uint8_t btn14;
    uint8_t btn15;
        

    void rxHandler();
//    void (*onUpdate)(uint8_t btnX, uint8_t btnY, uint8_t btnABCD, uint8_t btnSpecial);
    void (*onUpdate)(uint8_t btn00, uint8_t btn01, uint8_t btn02, uint8_t btn03, uint8_t btn04, uint8_t btn05, uint8_t btn06, uint8_t btn07, uint8_t btn08, uint8_t btn09, uint8_t btn10, uint8_t btn11, uint8_t btn12, uint8_t btn13,uint8_t btn14,uint8_t btn15, uint16_t gamePadVID, uint16_t gamePadPID );
    
    int report_id;
    void init();
    bool parseHidDescr();
};

//#endif

#endif
