/*
 * mbed LPC824-Max header
 *
 */

// If you use moving type winch , then should comment out followings !!
// #define FFWinchPhaseSetting  // Valid if Fix falling winch system is using.

#define __DEBUG__
#ifdef __DEBUG__
#define DEBUG_PRINT(...)  pc.printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)  ;
//#define DEBUG_PRINT(...)  1 ? (void)0 : pc.printf(__VA_ARGS__)
#endif
/* Information */
#define LatestUpDate "2016.09.27"
#define ProgramRevision "Rev 2.30" 
#define Author "Y.Saito(zinsor)"
#define Company "Revast Co.,Ltd"


/* Debug macro */
#define __DEBUG_L0__
#define __DEBUG_L1__
#define __DEBUG_L2__
#define __DEBUG_L3__
#define __DEBUG_L4__

#ifdef __DEBUG_L0__
    #define DEBUG_PRINT_L0(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L0(...) 
#endif
#ifdef __DEBUG_L1__
    #define DEBUG_PRINT_L1(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L1(...) 
#endif
#ifdef __DEBUG_L2__
    #define DEBUG_PRINT_L2(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L2(...) 
#endif
#ifdef __DEBUG_L3__
    #define DEBUG_PRINT_L3(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L3(...) 
#endif
#ifdef __DEBUG_L4__
    #define DEBUG_PRINT_L4(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L4(...) 
#endif

#define NumberOfI2CCommand 14

/* For resolver reader controller */
enum{
    I2C_CP_PREAMBLE_R,          // Preamble of command packet
    I2C_CP_COMMAND_R,           // instruction command
    I2C_CP_WDRAM_DIA_UPPER,     // motor1 rotation direction   
    I2C_CP_WDRAM_DIA_LOWER,     // motor1 rotation speed    
    I2C_CP_CCABLE_DIA_UPPER,    // motor1 current limit detection threshold upper byte 
    I2C_CP_CCABLE_DIA_LOWER,    // motor1 current limit detection threshold lower byte 
    I2C_CP_RESOLVER_RESO,       // motor1 current limit detection threshold upper byte
    I2C_CP_PRESET_CPOS_UPPER,   // reserved   
    I2C_CP_PRESET_CPOS_LOWER,   // reserved   
    I2C_CP_RES3,                // reserved   
    I2C_CP_RES4,                // reserved   
    I2C_CP_RES5,                // reserved  
    I2C_CP_RES6,                // reserved
    I2C_CP_RES7,                // reserved    
};

#define ROTATE_PER_RESOLUTION       24
#define REAL_THREAD_DIAMETER        63          // 60+3
//#define ROTATION_DISTANCE           197.82f     // (60+3)*3.14
#define ROTATION_PULSE_PER_1ROUND   16384       // 2^12(bit) * 4
#define PAI                         3.14159265359

/* ***************** */
/* Target definition */
/* ***************** */
#define I2C_ADDRESS_RESOLVER    0x02
#define Target_IIC_ADDR 0x02 // For Resolver count controller 


/* Command Packet */
#define CLEAR_RESOLVER_POSITION       'X'
#define HELLO_PACKET        'A'

#define LED_ON  0
#define LED_OFF 1