/*
 * mbed LPC824-Max header
 *
 */
 
#define __IIC_COMAMND_SEND__

/* Information */
#define LatestUpDate "2016.06.06"
#define ProgramRevision "Rev 2.1" 
#define Author "Y.Saito(zinsor)"
#define Company "Revast Co.,Ltd."
#define ProgramCode "RVM-X0F0A"

#define __DEBUG_L0__
#define __DEBUG_L1__
//#define __DEBUG_L2__
#define __DEBUG_L3__
//#define __DEBUG_L4__
#define __DEBUG_DSPMCNT__   // Display motor current percentage value

#ifdef __DEBUG_L0__
    #define DEBUG_PRINT_L0(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L0(...) 
#endif
#ifdef __DEBUG_L1__
    #define DEBUG_PRINT_L1(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L1(...) 
#endif
#ifdef __DEBUG_L2__
    #define DEBUG_PRINT_L2(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L2(...) 
#endif
#ifdef __DEBUG_L3__
    #define DEBUG_PRINT_L3(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L3(...) 
#endif
#ifdef __DEBUG_L4__
    #define DEBUG_PRINT_L4(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L4(...) 
#endif
#ifdef __DEBUG_DSPMCNT__
    #define DEBUG_DSPMCNT(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_DSPMCNT(...) 
#endif

/* Motor Controller I2C address definition */
#define I2C_ADDRESS_HANDY       0x20
#define I2C_ADDRESS_WINCH       0x10
#define I2C_ADDRESS_TRANSFORM   0x08
#define I2C_ADDRESS_CRAWLER     0x04
#define I2C_ADDRESS_RESOLVER    0x02


/* Command definition */
//#define I2C_TFM_RF_K        '6'   
//#define I2C_TFM_RF_I        '8' 
//#define I2C_TFM_LB_K        '7'
//#define I2C_TFM_LB_I        '5'
//#define I2C_TFM_PAN_CW      '2'
//#define I2C_TFM_PAN_CCW     '4'
//#define I2C_TFM_TILT_UP     '1'
//#define I2C_TFM_TILT_DWN    '3'  

/* Command definition */
#define MOTOR_1     '1'
#define MOTOR_2     '2'

#define MOTOR_FWD   'F'     /* Forward Rotation */
#define MOTOR_RVS   'R'     /* Reverse Rotation */
#define MOTOR_STP   'S'     /* Stop */

#define HELLO_PACKET        'A'
#define READ_MCURRENT_PACKET 'C'


#define MOTOR_ON            '0'
#define MOTOR_OFF           '1'

#define LED_ON  0
#define LED_OFF 1

#define FLG_MOTOR1  1
#define FLG_MOTOR2  2
#define FLG_MOTOR_ON    1
#define FLG_MOTOR_OFF   0

enum {
    FLG_MOTOR_DIR_FWD,
    FLG_MOTOR_DIR_RVS,
    FLG_MOTOR_DIR_NONE
};

/* I2C Command packet to motor controller */
/* For motor controller */
enum{
    I2C_CP_PREAMBLE,        // Preamble of command packet
    I2C_CP_COMMAND,         // instruction command
    I2C_CP_M1_DIR,          // motor1 rotation direction   
    I2C_CP_M1_SPEED,        // motor1 rotation speed    
    I2C_CP_M1_FWD_CNTTH_U,  // motor1 current limit detection threshold upper byte 
    I2C_CP_M1_FWD_CNTTH_L,  // motor1 current limit detection threshold lower byte 
    I2C_CP_M1_RVS_CNTTH_U,  // motor1 current limit detection threshold upper byte
    I2C_CP_M1_RVS_CNTTH_L,  // motor1 current limit detection threshold lower byte   
    I2C_CP_M2_DIR,          // motor2 rotation direction   
    I2C_CP_M2_SPEED,        // motor2 rotation speed   
    I2C_CP_M2_FWD_CNTTH_U,  // motor2 current limit detection threshold upper byte   
    I2C_CP_M2_FWD_CNTTH_L,  // motor2 current limit detection threshold lower byte  
    I2C_CP_M2_RVS_CNTTH_U,  // motor2 current limit detection threshold upper byte
    I2C_CP_M2_RVS_CNTTH_L,  // motor2 current limit detection threshold lower byte    
};

#define MC_UPPER_LIMIT    95.0f
#define MC_LOWER_LIMIT    5.0f  
#define MC_LOCK_COUNT     5

#define NumberOfPcCommand 11
#define NumberOfI2CCommand 14

#define ROTATE_PER_RESOLUTION 24
