#include "mbed.h"
#include "rtos.h"
#include "common.h"
#include "com_func.h"


void cf_led_onoff(
    DigitalOut *led1,
    DigitalOut *led2,
    DigitalOut *led3,
    DigitalOut *led4,
    bool led1_onoff,
    bool led2_onoff,
    bool led3_onoff,
    bool led4_onoff
){
    if (led1_onoff == true ) *led1 = 1;
    else *led1 = 0;
    if (led2_onoff == true ) *led2 = 1;
    else *led2 = 0;
    if (led3_onoff == true ) *led3 = 1;
    else *led3 = 0;
    if (led4_onoff == true ) *led4 = 1;
    else *led4 = 0;
}
   
// LED demo
void cf_led_demo(
    DigitalOut *led1,
    DigitalOut *led2,
    DigitalOut *led3,
    DigitalOut *led4,
    int cnt, 
    int wait
){
    for( int i = 0; i < cnt; i++ ) {
        *led1 = 1;   // on
        *led2 = 0;   // off
        *led3 = 0;   // off
        *led4 = 0;   // off
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 1;   // on
        *led3 = 0;   // off
        *led4 = 0;   // off
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 0;   // off
        *led3 = 1;   // on
        *led4 = 0;   // off
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 0;   // off
        *led3 = 0;   // off
        *led4 = 1;   // on
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 0;   // off
        *led3 = 0;   // off
        *led4 = 0;   // off
    }
}

void cf_led_error(
    DigitalOut *led1,
    DigitalOut *led2,
    DigitalOut *led3,
    DigitalOut *led4    
){
    for( int i = 0; i < 16; i++ ) {
        *led1 = 1;   // on
        *led2 = 1;   // off
        *led3 = 1;   // off
        *led4 = 1;   // off
        Thread::wait(30);
        *led1 = 0;   // off
        *led2 = 0;   // on
        *led3 = 0;   // off
        *led4 = 0;   // off
        Thread::wait(30);
    }
}

void dspSetValue2Console(Serial* pc, setValue_t * setValue){
    pc->printf("WinchDram motor Fwd rote current th: %04d %\r\n", setValue->winchCtrl.sv_WDM_ith_F);
    pc->printf("WinchDram motor Rvs rote current th: %04d %\r\n", setValue->winchCtrl.sv_WDM_ith_R);
    pc->printf("WinchM2 motor Fwd rote current th:   %04d %\r\n", setValue->winchCtrl.sv_WRM_ith_F);
    pc->printf("WinchM2 motor Rvs rote current th:   %04d %\r\n", setValue->winchCtrl.sv_WRM_ith_R);     
    pc->printf("WinchDram motor Fwd HighSpeed ratio: %03d %\r\n", setValue->winchCtrl.sv_WDM_hsrto_F);                
    pc->printf("WinchDram motor Rvs HighSpeed ratio: %03d %\r\n", setValue->winchCtrl.sv_WDM_hsrto_R);                
    pc->printf("WinchDram motor Fwd LowSpeed ratio:  %03d %\r\n", setValue->winchCtrl.sv_WDM_lsrto_F);                
    pc->printf("WinchDram motor Rvs LowSpeed ratio:  %03d %\r\n", setValue->winchCtrl.sv_WDM_lsrto_R);                
    pc->printf("WinchM2 motor Fwd HighSpeed ratio:   %03d %\r\n", setValue->winchCtrl.sv_WRM_hsrto_F);                
    pc->printf("WinchM2 motor Rvs HighSpeed ratio:   %03d %\r\n", setValue->winchCtrl.sv_WRM_hsrto_R);                
    pc->printf("WinchM2 motor Fwd LowSpeed ratio:    %03d %\r\n", setValue->winchCtrl.sv_WRM_lsrto_F);  
    pc->printf("WinchM2 motor Rvs LowSpeed ratio:    %03d %\r\n", setValue->winchCtrl.sv_WRM_lsrto_R);  
    pc->printf("Winch Dram diameter x 100:           %04d \r\n", setValue->winchCtrl.sv_WRS_DramDmrx100);  
    pc->printf("Winch C-Cable diamter x 100:         %04d \r\n", setValue->winchCtrl.sv_WRS_CCableDmrx100);  
    pc->printf("Winch Resolver resolution:           %03d bit\r\n", setValue->winchCtrl.sv_WRS_RResolution);  

    pc->printf("RF tfm motor Fwd rote current th:    %04d %\r\n", setValue->tfmCtrl.sv_RFTM_ith_F);
    pc->printf("RF tfm motor RVS rote current th:    %04d %\r\n", setValue->tfmCtrl.sv_RFTM_ith_R);
    pc->printf("LB tfm motor FWD rote current th:    %04d %\r\n", setValue->tfmCtrl.sv_LBTM_ith_F);
    pc->printf("LB tfm motor RVS rote current th:    %04d %\r\n", setValue->tfmCtrl.sv_LBTM_ith_R);
    pc->printf("RF tfm motor FWD Speed ratio:        %03d %\r\n", setValue->tfmCtrl.sv_RFTM_srto_F);                
    pc->printf("RF tfm motor RVS Speed ratio:        %03d %\r\n", setValue->tfmCtrl.sv_RFTM_srto_R);                
    pc->printf("LB tfm motor FWD Speed ratio:        %03d %\r\n", setValue->tfmCtrl.sv_LBTM_srto_F);                
    pc->printf("LB tfm motor RVS Speed ratio:        %03d %\r\n", setValue->tfmCtrl.sv_LBTM_srto_R);                

    pc->printf("R-Crawler Fwd rotation current th:   %04d %\r\n", setValue->crawlerCtrl.sv_RFCM_ith_F);
    pc->printf("R-Crawler Rvs rotation current th:   %04d %\r\n", setValue->crawlerCtrl.sv_RFCM_ith_R);
    pc->printf("L-Crawler Fwd rotation current th:   %04d %\r\n", setValue->crawlerCtrl.sv_LBCM_ith_F);
    pc->printf("L-Crawler Rvs rotation current th:   %04d %\r\n", setValue->crawlerCtrl.sv_LBCM_ith_R);
    pc->printf("R-Crawler Fwd rotation Speed ratio:  %03d %\r\n", setValue->crawlerCtrl.sv_RFCM_srto_F);
    pc->printf("R-Crawler Rvs rotation Speed ratio:  %03d %\r\n", setValue->crawlerCtrl.sv_RFCM_srto_R);                
    pc->printf("L-Crawler Fwd rotation Speed ratio:  %03d\r\n", setValue->crawlerCtrl.sv_LBCM_srto_F);                
    pc->printf("L-Crawler Rvs rotation Speed ratio:  %03d\r\n", setValue->crawlerCtrl.sv_LBCM_srto_R);                

    pc->printf("R-JS UpperDeadZone:                  %03d\r\n", setValue->crawlerCtrl.sv_RFCM_dzu);
    pc->printf("R-JS CenterValue:                    %03d\r\n", setValue->crawlerCtrl.sv_RFCM_dzc);
    pc->printf("R-JS LowerDeadZone:                  %03d\r\n", setValue->crawlerCtrl.sv_RFCM_dzl);
    pc->printf("L-JS UpperDeadZone:                  %03d\r\n", setValue->crawlerCtrl.sv_LBCM_dzu);              
    pc->printf("L-JS CenterValue:                    %03d\r\n", setValue->crawlerCtrl.sv_LBCM_dzc);              
    pc->printf("L-JS LowerDeadZone:                  %03d\r\n", setValue->crawlerCtrl.sv_LBCM_dzl);              

    pc->printf("Reserved1:                           %03d\r\n", setValue->crawlerCtrl.reserved1);              
    pc->printf("Reserved2:                           %03d\r\n", setValue->crawlerCtrl.reserved2);              

    pc->printf( "\r\n" );
}
