#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "common.h"
#include "stdio.h"
 
#define ECHO_SERVER_PORT   10004

/* Debug port */
Serial pc(USBTX, USBRX); // USBSerial serial setting

/* GPIO setting */
DigitalOut led1(LED1); // on board green
DigitalOut led2(LED2); // on board blue 
DigitalOut led3(LED3); // on board red

DigitalInOut OneAxisSliderPulse(PE_11, PIN_OUTPUT, OpenDrain, 0);
DigitalInOut OneAxisSliderDir(PE_9, PIN_OUTPUT, OpenDrain, 0);
// DigitalOut OneAxisSliderPulse(PE_9);
//DigitalOut OneAxisSliderDir(PE_11);

DigitalOut OneAxisSliderORG(PF_3);
DigitalOut OneAxisSliderReset(PF_15);
DigitalOut OneAxisSliderServoOn(PF_11);

DigitalOut Relay(PC_8);

//DigitalInOut lamp_out(p23, PIN_OUTPUT, OpenDrain, 0);
//DigitalInOut lamp_out(p23, PIN_OUTPUT, OpenDrain, 0);


DigitalOut out1( PG_9 );
AnalogOut linear_out( PA_5 );
AnalogOut linear_out2( PA_4 );

DigitalIn limit1_din(PG_5);    // limit1 in 
DigitalIn limit2_din(PG_6);    // limit2 in
AnalogIn weight_ain(PC_2);   // analog input of load cell


/* Network setting */
UDPSocket   userver; // UDP Server
const char* ip_address = "192.168.31.31";
const char* subnet_mask = "255.255.255.0";
const char* gateway = "192.168.31.0";

Thread thread1;
Thread thread2;
Thread thread3;   
Thread thread4;   

void move_distance( int dir , int dis_mm );

 
/* Thread routine */
void OneAxisSliderCtrl_thread() 
{
    OneAxisSliderReset = 1;
    led2 = 1;
    
    wait(1);
    led2 = 0;

    OneAxisSliderReset = 0;
    
    wait_ms(3000);
    
    led3 = 1;
    printf("Servo on\r\n");
    
    // ORG-S: OFF
    
    OneAxisSliderServoOn = 1;
    printf("Servo on\r\n");
    
    
    
    wait(1);
    OneAxisSliderORG = 1;
    printf("Move to Origin\r\n");

    // **************************************
    // while( ORG-S singnal is ON(=0V))
    // if slider is located to ORIGIN then OGG-S signal will be ON(0V) until next RESET or SERVO off
    // ORG-S: OFF
    // **************************************

    
    wait_ms(15000);
    
    wait(1);

    printf("1st move\r\n");
    move_distance( DIR_CCW, L_010mm * 30 );

    wait_ms(8000);
    
    while (true) 
    {
        while (true)
        {
            printf("CW move\r\n");
            move_distance( DIR_CW, L_010mm * 20 );
            
            wait_ms(8000);
            
  
  
            printf("CCW move\r\n");
            move_distance( DIR_CCW, L_010mm * 20 );
      
            break;
        }
        wait(1);
        printf(" weight: %d\r\n", weight_ain.read_u16());
    }
}




void move_distance( int dir , int dis_mm )
{
    OneAxisSliderDir = dir;
    wait(0.1);
    for( int i = 0; i < dis_mm; i++ )
    {
        OneAxisSliderPulse = MOTOR_ON;
        wait_us(5);
        OneAxisSliderPulse = MOTOR_OFF;
        wait_us(5);    
    }
}
    


void led3_thread() 
{
    while (true) 
    {
        Relay = 0;
    //    Thread::wait(BLINKING_RATE_MS-20);
        Thread::wait( 100 );
        Relay = 1;
        Thread::wait( 100 );
    }
}

void linear_thread()
{
    while( true )
    {
        for( double i=0.0; i<1.0; i+=0.001) {
            linear_out = i;
            Thread::wait(50);
        }        
    }
}

void network_thread()
{
    EthernetInterface eth;
    eth.init( ip_address, subnet_mask, gateway ); //Use DHCP
    eth.connect();
    printf("\nServer IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
        
    while (true) 
    {
        printf("\nWait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        while (true) 
        {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            led1 = 1;
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\r\n",buffer);
            
            if( !strcmp( buffer, "SLD_P0_0000" ) )
            {
                printf("Command: SLD move to position 0\r\n");
            }
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        client.close();
    }
}





int main (void) {
    
    pc.baud(115200); // Set UART(USB) baudrate
    DEBUG_PRINT_L0("\r\n");
    DEBUG_PRINT_L0(" +--------------------------------------------------------------\r\n");
    DEBUG_PRINT_L0(" | This is: Main Control Program of .....\r\n");
    DEBUG_PRINT_L0(" +--------------------------------------------------------------\r\n");    
  
    limit1_din.mode(PullUp);
    limit2_din.mode(PullUp);
//    Thread thread1(linear_thread, NULL, osPriorityNormal, 128 * 4);
//    Thread thread2(led2_thread, NULL, osPriorityNormal, 128 * 4);
//    Thread thread3(led3_thread, NULL, osPriorityNormal, 128 * 4);
    thread1.start(linear_thread);
    thread2.start(OneAxisSliderCtrl_thread);
    thread3.start(led3_thread);
    thread4.start(network_thread);

    //while (true) 
    //{
        //led1 = !led1;
        //Thread::wait(1);
        //SliderPulse = !SliderPulse;

    //}
}