/* 
   DEBUG PRINT MACRO
   http://qiita.com/saltheads/items/e1b0ab54d3d6029c9593
   http://tricky-code.net/nicecode/code10.php
*/
/* Information */
#define LatestUpDate    "2016.11.04"
#define ProgramRevision "Rev 2.40" 
#define Author          "ZisNotRevast"
#define Company         "Revast Co.,Ltd."

//#define __CREATE_SETTING_FILE__
//#define __TARGET_BOARD_CHECK__


//#define __WInchDebug__  // For debugging 


// Comment out if net setting is FIX.
// #define __NET_SETTING_FROM_LFS__


// Read motor current 
#define __READ_TFM_MOTOR_CURRENT__

#define __IIC_COMAMND_SEND__

#define __SET_WINCH_MOTOR_SPEED_BY_VOLUME__

// ======================================================================
// For Debugging
// ======================================================================
#define __DEBUG_PRINT_SW__  // Display SW Status to console
//#define __DEBUG_L0__
//#define __DEBUG_L1__
//#define __DEBUG_L2__
//#define __DEBUG_L3__
//#define __DEBUG_L4__
#define __DEBUG_L5__

#define __DEBUG_WINCH_DATA__


#ifdef __DEBUG_WINCH_DATA__
    #define DEBUG_PRINT_WINCH_DATA(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_WINCH_DATA(...) 
#endif

#ifdef __DEBUG_PRINT_SW__
    #define DEBUG_PRINT_SW(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_SW(...) 
#endif

#ifdef __DEBUG_L0__
    #define DEBUG_PRINT_L0(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L0(...) 
#endif
#ifdef __DEBUG_L1__
    #define DEBUG_PRINT_L1(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L1(...) 
#endif
#ifdef __DEBUG_L2__
    #define DEBUG_PRINT_L2(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L2(...) 
#endif
#ifdef __DEBUG_L3__
    #define DEBUG_PRINT_L3(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L3(...) 
#endif
#ifdef __DEBUG_L4__
    #define DEBUG_PRINT_L4(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L4(...) 
#endif
#ifdef __DEBUG_L5__
    #define DEBUG_PRINT_L5(...)  pc.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT_L5(...) 
#endif

// Motor Controller RoboCAN ID definition
#define MCTR_CANID_PANTILTWCH 2     // Pan/Tilt or Winch motor's ID
#define MCTR_CANID_TFM 3            // Trabsform motor's ID 
#define MCTR_CANID_CRW 1            // Crawler motor's ID

#define NUMBER_OF_MCCMD 7
#define WINCH_OFFSET_VALUE 20

#define LED_IND_BLINK_PERIOD 15
#define LED_IND_BLINK_PERIOD2 2
#define LED_IND_BLINK_PERIOD8 18

/*
 B1/B2 demo machine controller control command list
*/
enum{   
    XX_WICH,        // Winch
    XX_CLRF,        // R Crawler
    XX_CLLB,        // L Crawler
    XX_TFRF,        // R Transform
    XX_TFLB,        // R Transform
    ZTRF_I_1,       // RF-I Transform ON
    ZTRF_I_0,       // RF-I Transform OFF
    ZTRF_K_1,       // RF-K Transform ON
    ZTRF_K_0,       // RF-K Transform OFF
    ZTLB_I_1,       // LB-I Transform ON
    ZTLB_I_0,       // LB-I Transform OFF
    ZTLB_K_1,       // LB-K Transform ON
    ZTLB_K_0,       // LB-K Transform OFF   
    ZCP_FW_1,       // Camera PAN Forward ON
    ZCP_FW_0,       // Camera PAN Forward OFF
    ZCP_RS_1,       // Camera PAN Reverse ON
    ZCP_RS_0,       // Camera PAN Reverse OFF
    ZCT_FW_1,       // Camera TILT Forward ON
    ZCT_FW_0,       // Camera TILT Forward OFF
    ZCT_RS_1,       // Camera TILT Reverse ON
    ZCT_RS_0,       // Camera TILT Reverse OFF
    ZESHAPE_I,       // Shape I : Switch ON
    ZESHAPE_K,       // Shape K : Switch OFF
    ZTFCWP_VD,       // TFM,CRW Part valid : Switch ON
    ZWICHP_VD        // Winch Part valid : Switch OFF  
};    


enum{
    MOTOR_NO0,
    MOTOR_NO1,
    MOTOR_NO2,
    MOTOR_NO3
};

enum{
    MOTOR_FORWARD,
    MOTOR_REVERSE,
    MOTOR_STOP
};

#define MC_LOCK_COUNT     5

#define DEAD_ZONE_BAND_WIDTH 10
#define CALIBRATION_COUNT 300

/* ********************************************* */

#define MOTOR_1     '1'
#define MOTOR_2     '2'

#define MOTOR_

/* Above is still under construction ..... */

#define __DISP_GAMAPAD_STATUS_ALL__
#define __DISP_WRITE_VALUE__

#define I2C_ADDRESS_HANDY       0x20
#define I2C_ADDRESS_WINCH       0x10
#define I2C_ADDRESS_TRANSFORM   0x08
#define I2C_ADDRESS_CRAWLER     0x04
#define I2C_ADDRESS_RESOLVER    0x02


#define _OK_ 1
#define _NG_ 0
#define _FAIL_ 0

#define ON 1
#define OFF 0

#define LFS_READ_COUNT 3
#define TARGET_CHECK_COUNT 10

//#define __DSP_MOTOR_CURRENT_

/* Usually this should be comment out */
//#define _COMMUNCATE_PC_BY_SERIAL_

// Should validate this definition when you use DHCP.
//#define __ETERNET_DHCP__

#define NumberOfPcCommand 11
#define NumberOfI2CCommand 14

/* Winch Operating mode */
enum{
    WINCH_POSITION_CLEAR,
    WINCH_PRESET_BASEDATA,
    WINCH_MMODE_RELATIVE,
    WINCH_MMODE_ABSOLUTE,
    WINCH_STEPDOWN_BTN_ON,
    WINCH_STEPDOWN_BTN_OFF,
    WINCH_STEPUP_BTN_ON,
    WINCH_STEPUP_BTN_OFF,
    WINCH_U_STEPDOWN_BTN_ON,
    WINCH_U_STEPDOWN_BTN_OFF,
    WINCH_U_STEPUP_BTN_ON,
    WINCH_U_STEPUP_BTN_OFF,
    WINCH_PRESET_POSITION,
};

/* Game Pad defnition */
#define GAMEPAD_VID_LOGICOOL        0x046d
#define GAMEPAD_PID_LOGICOOL_F710   0xc219
#define GAMEPAD_PID_LOGICOOL_F310   0xc216

#define GAMEPAD_VID_SANWA           0x12bd
#define GAMEPAD_PID_SANWA_JYP70US   0xc003

#define GAMEPAD_VID_ELECOM          0x056e
#define GAMEPAD_PID_ELECOM_JCU3613M 0x2003

#define GAMEPAD_VID_RSTHANDY        0x1234
#define GAMEPAD_PID_RSTHANDY        0x0006


/* Ether net */
#define TCP_SERVER_PORT   10002
#define UDP_SERVER_PORT   10000
//#define ECHO_SERVER_PORT   7

#define MOTOR_FWD   'F'     /* Forward Rotation */
#define MOTOR_RVS   'R'     /* Reverse Rotation */
#define MOTOR_STP   'S'     /* Stop */

// =========================================================
// Setting Values
// =========================================================
typedef struct {
    int8_t  sv_JS_ShapeMode;    // JS Shape: 0=I, 1=KO
    int8_t  sv_JS_OpeMode;      // JS Operation: 0=single, 1=dual
    int8_t  sv_WinchValid;      // Winch function valid or not: 0=Tfm, Crawler valid, 1=Winch valid
    int8_t  res;
} basic_operation_t;

typedef struct {
    uint8_t     rjs_upper_dzone;     // 1 R Joystick upper dead zone width
    uint8_t     rjs_lower_dzone;     // 1 R Joystick lower dead zone width
    uint8_t     rjs_right_dzone;     // 1 R Joystick lower dead zone width
    uint8_t     rjs_left_dzone;      // 1 R Joystick lower dead zone width
    uint8_t     reserved_1;          // 1 reserved for future use
    uint8_t     reserved_2;          // 1 reserved for future use
    uint8_t     reserved_3;          // 1 reserved for future use
    uint8_t     reserved_4;          // 1 reserved for future use
} js_SetValue_t;  

typedef struct SetValue {
    js_SetValue_t           jsCtrl; 
} setValue_t;




#define SLOWDOWN_DISTANCE 23    // <--10 2016.06.01
#define SLOWDOWN_NEAR_DISTANCE 3
/*
typedef struct {
    int16_t dt_WinchCntPosition;    // Current winch posittion
    int16_t dt_WinchRtvValue;       // Winch Moving distance
    int16_t dt_WinchDstPosition;    // Destination Position
    char operation;
    int8_t  dt_WinchMotorCurrent;        // Winch motor current
} winchData_t;
*/

typedef struct {
    int16_t dt_WinchCntPosition;    // Current winch posittion
    int16_t dt_WinchRtvValue;       // Winch Moving distance
    int16_t dt_WinchDstPosition;    // Destination Position
    uint8_t operation;
    uint8_t dt_WinchMotor1Current;        // Winch motor 1 current
    uint8_t dt_WinchMotor2Current;        // Winch motor 2 current
    uint8_t res;
} winchData_t;


#define ROTATE_PER_RESOLUTION 24
  
#define __READ_CURRENT_AT_CIF_TASK__    

//mv_WinchMvData
