#include "mbed.h"
#include "rtos.h"
#include "common.h"
#include "com_func.h"


void cf_led_onoff(
    DigitalOut *led1,
    DigitalOut *led2,
    DigitalOut *led3,
    DigitalOut *led4,
    bool led1_onoff,
    bool led2_onoff,
    bool led3_onoff,
    bool led4_onoff
){
    if (led1_onoff == true ) *led1 = 1;
    else *led1 = 0;
    if (led2_onoff == true ) *led2 = 1;
    else *led2 = 0;
    if (led3_onoff == true ) *led3 = 1;
    else *led3 = 0;
    if (led4_onoff == true ) *led4 = 1;
    else *led4 = 0;
}
   
// LED demo
void cf_led_demo(
    DigitalOut *led1,
    DigitalOut *led2,
    DigitalOut *led3,
    DigitalOut *led4,
    int cnt, 
    int wait
){
    for( int i = 0; i < cnt; i++ ) {
        *led1 = 1;   // on
        *led2 = 0;   // off
        *led3 = 0;   // off
        *led4 = 0;   // off
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 1;   // on
        *led3 = 0;   // off
        *led4 = 0;   // off
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 0;   // off
        *led3 = 1;   // on
        *led4 = 0;   // off
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 0;   // off
        *led3 = 0;   // off
        *led4 = 1;   // on
        Thread::wait(wait);
        *led1 = 0;   // off
        *led2 = 0;   // off
        *led3 = 0;   // off
        *led4 = 0;   // off
    }
}

void cf_led_error(
    DigitalOut *led1,
    DigitalOut *led2,
    DigitalOut *led3,
    DigitalOut *led4    
){
    for( int i = 0; i < 16; i++ ) {
        *led1 = 1;   // on
        *led2 = 1;   // off
        *led3 = 1;   // off
        *led4 = 1;   // off
        Thread::wait(30);
        *led1 = 0;   // off
        *led2 = 0;   // on
        *led3 = 0;   // off
        *led4 = 0;   // off
        Thread::wait(30);
    }
}

