#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "common.h"
#include "com_func.h"
#include "music.h"

// JKSoft Blue mbed Board Specific Seting
AnalogOut   DACout(p18);
DigitalOut  AMPEnable(p12);

void waveMusic::wave(float volume , float fq , float time)
{
    float w_time = 1.0 / fq;

    AMPEnable = 0;
    for (float i=0; i<time / w_time; i++) {
        DACout = volume;
        wait(w_time/2);
        DACout = 0.0;
        wait(w_time/2);
    }
    AMPEnable = 1;
    
}

void waveMusic::pi( int count )
{
    for( int i=0; i < count; i++)
    {
        //    vol  freq    time
        wave( 0.3, 3000.0 * 1, 0.05 );    
        wave( 0.0, 3000.0 * 1, 0.05 );    
    }
    Thread::wait(80);  // msec  
}
 

void waveMusic::bz( int count )
{
    for( int i=0; i < count; i++)
    {
        //    vol  freq    time
        wave( 0.6, 3000.0, 0.1 );    
        wave( 0.0, 3000.0, 0.1 );    
    }
    Thread::wait(150);  // msec  
}

void waveMusic::bz_error( int count )
{
    for( int i=0; i < count; i++)
    {
        //    vol  freq    time
        wave( 0.6, 3000.0, 0.3 );    
        wave( 0.0, 3000.0, 0.3 );    
    }
    Thread::wait(300);  // msec  
}


void waveMusic::note( 
    float on_freq, 
    float on_time, 
    float off_time
){
    wave( 0.1, on_freq, on_time );    
    wave( 0.0, on_freq, off_time );    
}

void waveMusic::knkk( void )
{
    Thread::wait(300);  // msec  
    note( 146.82*3, 0.3, 0.08 ); // shi
    note( 220.00*3, 0.6, 0.08 ); // ra
    note( 246.94*3, 0.3, 0.08 ); // shi
/*    note( 261.63*3, 0.1, 0.02 ); // do 
    note( 261.63*3, 0.1, 0.02 ); // do 
    note( 246.94*3, 0.1, 0.02 ); // shi
    note( 220.00*3, 0.1, 0.02 ); // ra
    note( 146.835*3, 0.1, 0.02 ); // re
    note( 146.835*3, 0.1, 0.02 ); // re
    note( 146.835*3, 0.1, 0.02); // re
    note( 164.82*3, 0.1, 0.02 ); // mi
    note( 174.62*3, 0.3, 0.02 ); // fa */
    Thread::wait(300);  // msec  
}

void waveMusic::PC9801( void )
{
    Thread::wait(300);  // msec  
    note( 2000.0, 0.2, 0.05 ); // pi
    note( 1000.0, 0.2, 0.05 ); // po
    Thread::wait(300);  // msec  
}