#include "mbed.h"
#include "rtos.h"
#include "common.h"
#include "com_func.h"



void dspSetValue2Console(Serial* pc, setValue_t * setValue){
    pc->printf("WinchDram motor Fwd rote current th: %04d %\r\n", setValue->wchCtrl.drm_mtr_ithd_f);
    pc->printf("WinchDram motor Rvs rote current th: %04d %\r\n", setValue->wchCtrl.drm_mtr_ithd_r);
    pc->printf("WinchM2 motor Fwd rote current th:   %04d %\r\n", setValue->wchCtrl.no2_mtr_ithd_f);
    pc->printf("WinchM2 motor Rvs rote current th:   %04d %\r\n", setValue->wchCtrl.no2_mtr_ithd_r);     
    pc->printf("WinchDram motor Fwd HighSpeed ratio: %03d %\r\n", setValue->wchCtrl.drm_mtr_hspd_f);                
    pc->printf("WinchDram motor Rvs HighSpeed ratio: %03d %\r\n", setValue->wchCtrl.drm_mtr_hspd_r);                
    pc->printf("WinchM2 motor Fwd HighSpeed ratio:   %03d %\r\n", setValue->wchCtrl.no2_mtr_hspd_f);                
    pc->printf("WinchM2 motor Rvs HighSpeed ratio:   %03d %\r\n", setValue->wchCtrl.no2_mtr_hspd_r);                
    pc->printf("Winch Dram diameter x 100:           %04d \r\n", setValue->wchCtrl.dram_dmtr_x100);  
    pc->printf("Winch C-Cable diamter x 10000:       %04d \r\n", setValue->wchCtrl.adj_val_x10000);  
    pc->printf("Winch Resolver resolution:           %03d bit\r\n", setValue->wchCtrl.res_resolution);  

    pc->printf("RF tfm motor Fwd rote current th:    %04d %\r\n", setValue->tfmCtrl.rf_mtr_ithd_f);
    pc->printf("RF tfm motor RVS rote current th:    %04d %\r\n", setValue->tfmCtrl.rf_mtr_ithd_r);
    pc->printf("LB tfm motor FWD rote current th:    %04d %\r\n", setValue->tfmCtrl.lb_mtr_ithd_f);
    pc->printf("LB tfm motor RVS rote current th:    %04d %\r\n", setValue->tfmCtrl.lb_mtr_ithd_r);
    pc->printf("RF tfm motor FWD Speed ratio:        %03d %\r\n", setValue->tfmCtrl.rf_mtr_hspd_f);                
    pc->printf("RF tfm motor RVS Speed ratio:        %03d %\r\n", setValue->tfmCtrl.rf_mtr_hspd_r);                
    pc->printf("LB tfm motor FWD Speed ratio:        %03d %\r\n", setValue->tfmCtrl.lb_mtr_hspd_f);                
    pc->printf("LB tfm motor RVS Speed ratio:        %03d %\r\n", setValue->tfmCtrl.lb_mtr_hspd_r);                

    pc->printf("R-Crawler Fwd rotation current th:   %04d %\r\n", setValue->crwCtrl.rf_mtr_ithd_f);
    pc->printf("R-Crawler Rvs rotation current th:   %04d %\r\n", setValue->crwCtrl.rf_mtr_ithd_r);
    pc->printf("L-Crawler Fwd rotation current th:   %04d %\r\n", setValue->crwCtrl.lb_mtr_ithd_f);
    pc->printf("L-Crawler Rvs rotation current th:   %04d %\r\n", setValue->crwCtrl.lb_mtr_ithd_r);
    pc->printf("R-Crawler Fwd rotation Speed ratio:  %03d %\r\n", setValue->crwCtrl.rf_mtr_hspd_f);
    pc->printf("R-Crawler Rvs rotation Speed ratio:  %03d %\r\n", setValue->crwCtrl.rf_mtr_hspd_r);                
    pc->printf("L-Crawler Fwd rotation Speed ratio:  %03d\r\n", setValue->crwCtrl.lb_mtr_hspd_f);                
    pc->printf("L-Crawler Rvs rotation Speed ratio:  %03d\r\n", setValue->crwCtrl.lb_mtr_hspd_r);                

    pc->printf( "\r\n" );
}
