#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "common.h"
#include "com_func.h"
#include "ledCtrl.h"

// Digital I/O setting
DigitalOut led_1(LED1);          // 1:on,0:off  System is OK then ON.
DigitalOut led_2(LED2);          // 1:on,0:off  HandyController(or PC) is connected by LAN.
DigitalOut led_3(LED3);          // 1:on,0:off  When got the GamePas switch input then ON  
DigitalOut led_4(LED4);          // 1:on,0:off  ERROR

DigitalOut led_main(p24);        // 1:on,0:off  Main LED indicator at front of main box.

void ledCtrl::led_on(
    int led_no
){
    if( led_no == 1 )   led_1 = 1;
    if( led_no == 2 )   led_2 = 1;
    if( led_no == 3 )   led_3 = 1;
    if( led_no == 4 )   led_4 = 1;
}

void ledCtrl::led_off(
    int led_no
){
    if( led_no == 1 )   led_1 = 0;
    if( led_no == 2 )   led_2 = 0;
    if( led_no == 3 )   led_3 = 0;
    if( led_no == 4 )   led_4 = 0;
}

// LED demo
void ledCtrl::led_demo(
    int cnt, 
    int wait
){
    for( int i = 0; i < cnt; i++ ) {
        led_1 = 1;   // on
        led_2 = 0;   // off
        led_3 = 0;   // off
        led_4 = 0;   // off
        Thread::wait(wait);
        led_1 = 0;   // off
        led_2 = 1;   // on
        led_3 = 0;   // off
        led_4 = 0;   // off
        Thread::wait(wait);
        led_1 = 0;   // off
        led_2 = 0;   // off
        led_3 = 1;   // on
        led_4 = 0;   // off
        Thread::wait(wait);
        led_1 = 0;   // off
        led_2 = 0;   // off
        led_3 = 0;   // off
        led_4 = 1;   // on
        Thread::wait(wait);
        led_1 = 0;   // off
        led_2 = 0;   // off
        led_3 = 0;   // off
        led_4 = 0;   // off
    }
}

void ledCtrl::led_error(){
    for( int i = 0; i < 16; i++ ) {
        led_4 = 1;   // off
        Thread::wait(30);
        led_4 = 0;   // off
        Thread::wait(30);
    }
}


void ledCtrl::led_main_on( void )
{
    led_main = 1;
}

void ledCtrl::led_main_off( void )
{
    led_main = 0;
}

void ledCtrl::led_main_blink( int times )
{
    for( int i = 0; i < times; i++ ) {
        led_main = 1;   // off
        Thread::wait(100);
        led_main = 0;   // off
        Thread::wait(100);
    }
}

void ledCtrl::led_main_error(){
    for( int i = 0; i < 16; i++ ) {
        led_main = 1;   // off
        Thread::wait(50);
        led_main = 0;   // off
        Thread::wait(50);
    }
}