#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "common.h"
#include "com_func.h"
#include "lfsAccess.h"


bool lfsAccess::readSetting( int dspSetting )
{
    FILE    *fp;
    char    *fname = "/local/dset.txt"; 
    char    s[150];
    int     c;
    int     data;
    
    fp = fopen(fname, "r");
    if( fp != NULL ){  // Open "set.txt" on the local file system for writing
        c = getc(fp);
        if( c != '#' ){
            return false;
        }
        else{
            fgets(s,100,fp);

            fscanf(fp,"%04d",&data); setValue.crwCtrl.rf_mtr_ithd_f = data; fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.crwCtrl.rf_mtr_ithd_r = data; fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.crwCtrl.lb_mtr_ithd_f = data; fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.crwCtrl.lb_mtr_ithd_r = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.rf_mtr_hspd_f = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.rf_mtr_hspd_r = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.lb_mtr_hspd_f = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.lb_mtr_hspd_r = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.reserved_1 = data;    fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.reserved_2 = data;    fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.reserved_3 = data;    fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.crwCtrl.reserved_4 = data;    fgets(s,100,fp); 

            fscanf(fp,"%04d",&data); setValue.tfmCtrl.rf_mtr_ithd_f = data;     fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.tfmCtrl.rf_mtr_ithd_r = data;     fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.tfmCtrl.lb_mtr_ithd_f = data;     fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.tfmCtrl.lb_mtr_ithd_r = data;     fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.rf_mtr_hspd_f = data;     fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.rf_mtr_hspd_r = data;     fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.lb_mtr_hspd_f = data;     fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.lb_mtr_hspd_r = data;     fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.reserved_1 = data;        fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.reserved_2 = data;        fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.reserved_3 = data;        fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.reserved_4 = data;        fgets(s,100,fp); 

            fscanf(fp,"%04d",&data); setValue.ptlCtrl.pan_mtr_ithd_f = data;  fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.ptlCtrl.pan_mtr_ithd_r = data;  fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.ptlCtrl.tlt_mtr_ithd_f = data;  fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.ptlCtrl.tlt_mtr_ithd_r = data;  fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.pan_mtr_hspd_f = data;  fgets(s,100,fp);
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.pan_mtr_hspd_r = data;  fgets(s,100,fp);
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.tlt_mtr_hspd_f = data;  fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.tlt_mtr_hspd_r = data;  fgets(s,100,fp);
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.reserved_1 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.reserved_2 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.ptlCtrl.reserved_3 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.tfmCtrl.reserved_4 = data;      fgets(s,100,fp); 

            fscanf(fp,"%04d",&data); setValue.wchCtrl.drm_mtr_ithd_f = data;  fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.wchCtrl.drm_mtr_ithd_r = data;  fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.wchCtrl.no2_mtr_ithd_f = data;  fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.wchCtrl.no2_mtr_ithd_r = data;  fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.drm_mtr_hspd_f = data;  fgets(s,100,fp);
            fscanf(fp,"%03d",&data); setValue.wchCtrl.drm_mtr_hspd_r = data;  fgets(s,100,fp);
            fscanf(fp,"%03d",&data); setValue.wchCtrl.no2_mtr_hspd_f = data;  fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.no2_mtr_hspd_r = data;  fgets(s,100,fp);
            fscanf(fp,"%05d",&data); setValue.wchCtrl.dram_dmtr_x100 = data;  fgets(s,100,fp); 
            fscanf(fp,"%05d",&data); setValue.wchCtrl.adj_val_x10000 = data;  fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.res_resolution = data;  fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_1 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_2 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_3 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_4 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_5 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_6 = data;      fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_7 = data;      fgets(s,100,fp); 
        }
        fclose(fp);
    }
    else{
        return false;
    }
    return true; 
}


bool lfsAccess::write_LFS_data( char *fname, char* data )
{
    FILE    *fp;
    
    fp = fopen( fname, "a" );
    if( fp != NULL ){ 
        fprintf(fp, data );
        fprintf(fp, "\r\n" );
        Thread::wait(30);
        fclose(fp);
        Thread::wait(30);
    }
    else{
        return false;
    }  
    return true;
}

