/* Information */
#define LatestUpDate "2017.08.30"
#define ProgramRevision "Rev 2.30" 
#define Author "Y.Saito(zinsor)"
#define Company "Revast Co.,Ltd"


/* ****************************************** */
/* Motor                                      */
/* ****************************************** */
enum{
    MOTOR_RFCRW,        // RF crawler
    MOTOR_LBCRW,        // LB crawler
    MOTOR_RFTFM,        // RF Transform
    MOTOR_LBTFM,        // LB transform
    MOTOR_WINCH,        // Winch
    MOTOR_CMPAN,        // Pan
    MOTOR_CTILT,        // Tilt
    MOTOR_CABLE         // Cable transfar
};

enum{
    MOTOR_DIR_FWD,      // Motor forwaed rotation
    MOTOR_DIR_RVS,      // Motor reverse rotation
    MOTOR_DIR_STP       // Motor stop
};


enum{
    MOTOR_NO0,
    MOTOR_NO1,
    MOTOR_NO2,
    MOTOR_NO3
};

/* ****************************************** */
/* I2C                                        */
/* ****************************************** */
#define NumberOfI2CCommand 12
enum{
    I2C_CP_COMMAND,                   // instruction command
    I2C_CP_MOTORNO,                   // motor number
    I2C_CP_M_DIR,                     // motor rotation direction   
    I2C_CP_M_CNTTH_U,                 // motor current limit detection threshold upper byte 
    I2C_CP_M_CNTTH_L,                 // motor current limit detection threshold lower byte 
    I2C_CP_WDRAM_DIA_X100_UPPER,      // winch dram motor diameter upper
    I2C_CP_WDRAM_DIA_X100_LOWER,      // winch dram motor diameter lower
    I2C_CP_ADJUST_VALUE_X10000_UPPER, // cable diameter upper byte
    I2C_CP_ADJUST_VALUE_X10000_LOWER, // cable diameter lower byte
    I2C_CP_RESOLVER_RESO,             // resolver resolution (bit)
    I2C_CP_PRESET_CPOS_UPPER,         // preset position upper
    I2C_CP_PRESET_CPOS_LOWER          // preset position lower
};

#define I2C_ADDRESS_RESOLVER    0x02


/* ****************************************** */
/* Parameters                                 */
/* ****************************************** */
#define MAX_DROP_AMOUNT     3495         /* Maxmun dropping distance : ex 3500 (mm) */
#define DROP_AMOUNT_ADJ     10          /* Maxmun dropping distance : ex 3500 (mm) */

#define CALIBRATION_COUNT 300             /* Joystick calibration count */
#define DEAD_BAND 5                       /* Joystick dead band wide */

#define ROTATE_PER_RESOLUTION    24       /* For QEI */
#define PAI    3.14159265359

#define LED_ON  0
#define LED_OFF 1


/* ****************************************** */
/* Structure                                  */
/* ****************************************** */
/* Winch setting value */
typedef struct {
    uint16_t    cth_dram_mtr_f;      // 2 Current threshold: winch dram Motor ( forward )
    uint16_t    cth_dram_mtr_r;      // 2 Current threshold: winch dram Motor ( reverse )
    uint16_t    cth_cabl_mtr_f;      // 2 Current threshold: winch cable Motor ( forward )
    uint16_t    cth_cabl_mtr_r;      // 2 Current threshold: winch cable Motor ( reverse )
    uint16_t    dram_dmtr_x100;      // 2 Winch dram diameter x 100
    uint16_t    adj_val_x10000;      // 2 Winch adjust value x 100
    uint8_t     res_resolution;      // 2 Winch resolver resolution (bit)
    uint8_t     reserved_1;          // 1 reserved for future use
    uint8_t     reserved_2;          // 1 reserved for future use
    uint8_t     reserved_3;          // 1 reserved for future use
} wch_SetValue_t;   

typedef struct SetValue {
    wch_SetValue_t      wchCtrl;
} setValue_t;

