#include "mbed.h"
#include "stdio.h"
#include "common.h"
#include "music.h"

// JKSoft Blue mbed Board Specific Seting
AnalogOut   DACout(p18);
DigitalOut  AMPEnable(p12);

void waveMusic::wave(float volume , float fq , float time)
{
    float w_time = 1.0 / fq;

    AMPEnable = 0;
    for (float i=0; i<time / w_time; i++) {
        DACout = volume;
        wait(w_time/2);
        DACout = 0.0;
        wait(w_time/2);
    }
    AMPEnable = 1;
    
}

void waveMusic::pi( int count )
{
    for( int i=0; i < count; i++)
    {
        //    vol  freq    time
        wave( 0.8, 3000.0 * 1, 0.1 );    
        wave( 0.0, 3000.0 * 1, 0.1 );    
    }
    Thread::wait(80);  // msec  
}
 

void waveMusic::bz( int count )
{
    for( int i=0; i < count; i++)
    {
        //    vol  freq    time
        wave( 0.6, 3000.0, 0.1 );    
        wave( 0.0, 3000.0, 0.1 );    
    }
    Thread::wait(150);  // msec  
}

void waveMusic::bz_error( int count )
{
    for( int i=0; i < count; i++)
    {
        //    vol  freq    time
        wave( 0.6, 3000.0, 0.3 );    
        wave( 0.0, 3000.0, 0.3 );    
    }
    Thread::wait(300);  // msec  
}


void waveMusic::note( 
    float on_freq, 
    float on_time, 
    float off_time
){
    wave( 0.03, on_freq, on_time );    
    wave( 0.0, on_freq, off_time );    
}

void waveMusic::m_poteto( int count )
{
    for( int i=0; i < count; i++)
    {    
        Thread::wait(30);  // msec  
        note( 392.00*3, 0.2, 0.01 ); // so
        note( 329.00*3, 0.3, 0.01 ); // mi
        note( 392.00*3, 0.2, 0.01 ); // so
        Thread::wait(30);  // msec 
    }
}

void waveMusic::knkk( void )
{
    Thread::wait(300);  // msec  
    note( 146.82*3, 0.3, 0.08 ); // shi
    note( 220.00*3, 0.6, 0.08 ); // ra
    note( 246.94*3, 0.3, 0.08 ); // shi
/*    note( 261.63*3, 0.1, 0.02 ); // do 
    note( 261.63*3, 0.1, 0.02 ); // do 
    note( 246.94*3, 0.1, 0.02 ); // shi
    note( 220.00*3, 0.1, 0.02 ); // ra
    note( 146.835*3, 0.1, 0.02 ); // re
    note( 146.835*3, 0.1, 0.02 ); // re
    note( 146.835*3, 0.1, 0.02); // re
    note( 164.82*3, 0.1, 0.02 ); // mi
    note( 174.62*3, 0.3, 0.02 ); // fa */
    Thread::wait(300);  // msec  
}

void waveMusic::PC9801( void )
{
    Thread::wait(300);  // msec  
    note( 2000.0, 0.2, 0.05 ); // pi
    note( 1000.0, 0.2, 0.05 ); // po
    Thread::wait(300);  // msec  
}

//#define ON_TIME 0.08
//#define OFF_TIME 0.008
#define ON_TIME 0.08
#define OFF_TIME 0.008
void waveMusic::FFPre(void)
{
    Thread::wait(300);  // msec  
//    note( 130.815*3, ON_TIME, OFF_TIME ); // do
//    note( 146.835*3, ON_TIME, OFF_TIME ); // re
//    note( 164.820*3, ON_TIME, OFF_TIME ); // mi
//    note( 196.000*3, ON_TIME, OFF_TIME ); // so

    note( 261.630*2, ON_TIME, OFF_TIME ); // do
    note( 293.670*2, ON_TIME, OFF_TIME ); // re
    note( 329.630*2, ON_TIME, OFF_TIME ); // mi
    note( 392.000*2, ON_TIME, OFF_TIME ); // so
    
    note( 523.230*2, ON_TIME, OFF_TIME ); // do
    note( 587.340*2, ON_TIME, OFF_TIME ); // re
    note( 659.250*2, ON_TIME, OFF_TIME ); // mi
    note( 783.980*2, ON_TIME, OFF_TIME*2 ); // so

    note( 1046.500*2, ON_TIME, OFF_TIME ); // do
    note( 1174.700*2, ON_TIME, OFF_TIME ); // re
    note( 1318.600*2, ON_TIME, OFF_TIME ); // mi
    note( 1567.960*2, ON_TIME, OFF_TIME ); // so  

    note( 2093.000*2, ON_TIME, OFF_TIME ); // do    
    note( 1567.960*2, ON_TIME, OFF_TIME ); // so
    note( 1318.600*2, ON_TIME, OFF_TIME ); // mi 
    note( 1174.700*2, ON_TIME, OFF_TIME ); // re 

    note( 1046.500*2, ON_TIME, OFF_TIME ); // do   
    note( 783.980*2, ON_TIME, OFF_TIME );  // so
    note( 659.250*2, ON_TIME, OFF_TIME );  // mi
    note( 587.340*2, ON_TIME, OFF_TIME );  // re
    
    note( 523.230*2, ON_TIME, OFF_TIME ); // do
    note( 392.000*2, ON_TIME, OFF_TIME ); // so
    note( 329.630*2, ON_TIME, OFF_TIME ); // mi
    note( 293.670*2, ON_TIME, OFF_TIME ); // re
       
//    Thread::wait(300);  // msec  
}
